// =====================================================================
//  $Id: regex2.cc,v 1.3 2004/01/29 04:46:40 goiwai Exp $
//  $Name: CLDAQ-1-14-02 $
//  $Log: regex2.cc,v $
//  Revision 1.3  2004/01/29 04:46:40  goiwai
//  TRegularExpressionTUtillitiesѹˤΤǤ.
//
//  Revision 1.2  2003/11/27 04:34:53  goiwai
//  *** empty log message ***
//
//  Revision 1.1  2003/11/27 00:10:16  goiwai
//  ɽ᤹ TRegularExpression λ㤽2
//  ֥ޥåμ谷ʤ󤫤äƤޤ.
//
// =====================================================================
#include "TRegularExpression.hh"
#include "TBenchmark.hh"
#include "TOption.hh"
#include "TOptionTable.hh"
#include "TArgument.hh"

int main( int argc, char** argv, char** envv )
{
  const Tstring usage =
    "regex2 - Divide filename with dot."
    "\n"
    "Usage: regex2 [FILE]..."
    "\n"
    "\t"
    "% regex2 *";
  TArgument arg( argc, argv, usage );
  if ( arg.GetNumberOfElements() == 0 ) {
    arg.ShowUsage();
  }

  // "." ɽǤϡֲԤǤդ1פȤ̤ʰ̣
  // ʸ ȤƤ "."  "\." ʤΤ C++ Ǥ "\\." Ȥʤ
  const Tstring pattern = "^(.*)\\.(.*)$";
  Tcout << "PATTERN: \"" << pattern << "\"" << Tendl;
  TRegularExpression regex( pattern );
  for ( Tint i = 0; i < arg.GetNumberOfElements(); i ++ ) {
    Tstring dn = dirname( arg[i] );
    Tstring bn = basename( arg[i] );
    Tcout << "DIR: \"" << dn << "\", ";
    Tcout << "BASE: \"" << bn << "\", ";

    TstringList s = regex.GetSubMatch( bn );
    if ( s.size() != 2 ) {
      Tcout << "\"" << bn << "\" has not dot." << Tendl;
    } else {
      Tcout << "BODY: \"" << s[0] << "\", EXT: \"" << s[1] << "\"" << Tendl;
    }
  }

  return 0;
}
