// =====================================================================
//  $Id: Sw00RunAction.hh,v 1.6 2004/03/04 15:11:54 goiwai Exp $
//  $Name: CLDAQ-1-14-03 $
//  $Log: Sw00RunAction.hh,v $
//  Revision 1.6  2004/03/04 15:11:54  goiwai
//  ۤȤɤؿ̾ѹˤȤʤǤ
//
//  Revision 1.5  2004/01/19 21:10:27  goiwai
//  ץץåƬCLDAQ__ѹޤ.
//
//  Revision 1.4  2003/10/06 16:28:16  goiwai
//  *** empty log message ***
//
//  Revision 1.3  2003/07/30 16:15:16  goiwai
//  ե˥ߥåȥĤ뤳Ȥˤޤ.
//
// =====================================================================
#ifndef CLDAQ__SW00RUNACTION_HH
#define CLDAQ__SW00RUNACTION_HH

#include "TRunAction.hh"
#include "TOutputHtmlFileStream.hh"
#include "Sw00RunSummary.hh"

class TRun;
class TOutputObjectFile;
class TDataRecord;

class Sw00RunAction
  : public TRunAction
{

  private:
    TOutputObjectFile* theOutputFile;
    TOutputHtmlFileStream theOutputHtml;
    Sw00RunSummary theRunSummary;

  public:
    Sw00RunAction();
    ~Sw00RunAction();

  public:
    Tvoid Start( TRun& aRun );
    Tvoid Stop( TRun& aRun );

  public:
    TOutputObjectFile* GetOutputFile() const;
    TOutputHtmlFileStream& GetOutputHtml();
    const Sw00RunSummary& GetRunSummary() const;

  private:
    Tvoid fillRunBeginInformation( const TDataRecord& record );
    Tvoid fillRunEndInformation( const TDataRecord& record );
    Tvoid fillHtmlFile();

};

inline TOutputObjectFile* Sw00RunAction::GetOutputFile() const
{
  return theOutputFile;
}

inline TOutputHtmlFileStream& Sw00RunAction::GetOutputHtml()
{
  return theOutputHtml;
}

inline const Sw00RunSummary& Sw00RunAction::GetRunSummary() const
{
  return theRunSummary;
}

#endif
