// =====================================================================
//  $Id: sw00fadcview.cc,v 1.4 2003/10/12 13:08:47 goiwai Exp $
//  $Name: CLDAQ-1-14-03 $
//  $Log: sw00fadcview.cc,v $
//  Revision 1.4  2003/10/12 13:08:47  goiwai
//  饤Τۤ TInputObjectFileOnline Ȥ褦ˤޤ.
//
//  Revision 1.3  2003/10/06 16:28:16  goiwai
//  *** empty log message ***
//
//  Revision 1.2  2003/07/30 16:15:16  goiwai
//  ե˥ߥåȥĤ뤳Ȥˤޤ.
//
// =====================================================================
#include "TDataRecord.hh"
#include "TDataSection.hh"
#include "TDataSegment.hh"
#include "TDataElement.hh"
#include "TInputObjectFileOnline.hh"
#include "Trootinit.h"

int main( int argc, char** argv, char** envv )
{
  if ( argc != 2 ) {
    Tcerr << "usage: " << argv[ 0 ] << Tspace << "<filename>" << Tendl;
    return -1;
  }

  TApplication* theApplication = rootinit();

  Tstring filename = argv[ 1 ];
  TInputObjectFileOnline ifile( filename );


  TCanvas* canvas = new TCanvas( "adc", "Flash ADC", 640, 640 );
  TH2D* fadc = new TH2D( "fadc", "FADC Pulse Height Map", 8, 0.0, 256.0, 8, 0.0, 256.0 );
  fadc -> SetStats( 0 );
  fadc -> Draw( "col" );


  Tstring idset[ 2 ] = { "Event Data", "Flash ADC" };
  TDataRecord record;


  while ( ifile.Read( record ) ) {

    Tstring recid = record.GetID();

    if ( recid == "RUN BEGIN" ) {
      continue;
    } else if ( recid == "RUN END" ) {
      break;
    } else if ( recid == "EVENT" ) {

      TDataSegment segment;
      record.FindDataSegment( idset, segment );

      TDataElement element = segment[ 0 ];
      TUshort* data = element.GetUnsignedShortData();
      //Tint nprimitives = element.GetNumberOfPrimitives();
      fadc -> Reset();
      for ( Tint x = 0; x < 256; x ++ ) {
        for ( Tint y = 0; y < 256; y ++ ) {
          fadc -> Fill( x, y, (Tdouble)( *data ) );
          data ++;
        }
      }

      canvas -> Modified();
      canvas -> Update();

    } else {
      break;
    }

    gSystem -> ProcessEvents();

  }

  theApplication -> Run();

  return 0;
}
