// =====================================================================
//  $Id: sw01g4view.cc,v 1.1 2004/03/01 09:48:30 goiwai Exp $
//  $Name: CLDAQ-1-14-03 $
//  $Log: sw01g4view.cc,v $
//  Revision 1.1  2004/03/01 09:48:30  goiwai
//  sw01θǤѹǤ.
//  ۤȤƤѤޤ.
//  ̵Υ٥ȥǥץ쥤Ѱդޤ.
//
// =====================================================================
#include "TOption.hh"
#include "TArgument.hh"
#include "TDataRecord.hh"
#include "TDataSection.hh"
#include "TDataSegment.hh"
#include "TDataElement.hh"
#include "TInputObjectFileOnline.hh"
#include "Trootinit.h"

int main( int argc, char** argv, char** envv )
{
  TArgument arg( argc, argv );
  if ( arg.GetNumberOfElements() != 1 || !isexist( arg[0] ) ) {
    arg.ShowUsage();
  }

  TApplication* theApplication = rootinit( "Default", "SW01 Geant4 DISPLAY" );
  Tstring filename = arg[0];
  TInputObjectFileOnline ifile( filename );

  TCanvas* cv = new TCanvas( "cv", "Geant4 View" );
  cv -> SetFillColor(21);
  cv -> SetFrameFillColor(41);

  cv -> ToggleEventStatus();
  cv -> SetGridx();
  TH1D* hist = new TH1D( "hist", "Beam Energy Spectrum", 6, 0, 6 );
  hist -> SetFillColor(33);
  hist -> GetXaxis() -> SetNdivisions(6);
  hist -> GetXaxis() -> CenterLabels();
  hist -> GetXaxis() -> SetTitle("CCD ID");
  hist -> GetYaxis() -> SetTitle("#DeltaE (MeV)");
  hist -> Draw();

  TDataRecord record;
  while ( ifile.Read( record ) ) {
    Tstring recid = record.GetID();
    if ( record == "EVENT" ) {
      Tdouble ccdid, edep;
      record[0][3][0].StorePrimitive(ccdid);
      record[0][3][1].StorePrimitive(edep);
      hist -> Fill( ccdid, edep );
      cv -> Modified();
      cv -> Update();
    } else if ( record == "RUN END" ) {
      break;
    }
    gSystem -> ProcessEvents();
  }

  cv->Modified();
  cv->Update();
  cv->cd();

  theApplication -> Run();
  return 0;
}
