// =====================================================================
//  $Id: St02ReadoutBookDefinition.cc,v 1.4 2003/10/12 23:00:50 goiwai Exp $
//  $Name: CLDAQ-1-14-03 $
//  $Log: St02ReadoutBookDefinition.cc,v $
//  Revision 1.4  2003/10/12 23:00:50  goiwai
//  ⥸塼뤬Ū˥ޥ᡼饽᡼ˤʤäȤˤ
//  ѹǤ.
//
//  Revision 1.3  2003/10/06 16:28:19  goiwai
//  *** empty log message ***
//
//  Revision 1.2  2003/07/30 16:16:34  goiwai
//  ե˥ߥåȥĤ뤳Ȥˤޤ.
//
// =====================================================================
#include "TReadoutList.hh"
#include "TReadoutSection.hh"
#include "TReadoutSegment.hh"
#include "TCrate.hh"
#include "TReadoutBook.hh"

#include "St02ReadoutBookDefinition.hh"

St02ReadoutBookDefinition::St02ReadoutBookDefinition()
  : TReadoutBookDefinition()
{;}

St02ReadoutBookDefinition::~St02ReadoutBookDefinition()
{;}

TReadoutBook* St02ReadoutBookDefinition::Define()
{
  TReadoutBook* book = new TReadoutBook();


  // set segement from crate
  TReadoutSegment runid( theCrate -> GetModule( "runid" ), "RUN ID" );
  TReadoutSegment runinfo( theCrate -> GetModule( "runinfo" ), "RUN INFO" );
  TReadoutSegment clock( theCrate -> GetModule( "clock" ), "CLOCK" );
  TReadoutSegment timer( theCrate -> GetModule( "timer" ), "TIMER" );
  TReadoutSegment eventid( theCrate -> GetModule( "evtid" ), "EVENT ID" );
  TReadoutSegment fadc( theCrate -> GetModule( "daughter" ), "ADC" );
  // with MultiMeter
  // TReadoutSegment mm( theCrate -> GetModule( "multi meter" ), "KEITHLEY" );
  // with SourceMeter
  TReadoutSegment mm( theCrate -> GetModule( "source meter" ), "KEITHLEY" );


  // define readout at run begin
  TReadoutList* runbegin = new TReadoutList( "RUN BEGIN" );
  TReadoutSection sec0( "INFO" );
  sec0.push_back( runid );
  sec0.push_back( runinfo );
  sec0.push_back( clock );
  sec0.push_back( timer );
  runbegin -> push_back( sec0 );



  // define readout at end record
  TReadoutList* runend = new TReadoutList( "RUN END" );
  TReadoutSection sec1( "INFO" );
  sec1.push_back( runinfo );
  sec1.push_back( clock );
  sec1.push_back( timer );
  runend -> push_back( sec1 );



  // define event record
  TReadoutList* event = new TReadoutList( "EVENT" );
  TReadoutSection sec2( "INFO" );
  sec2.push_back( eventid );
  sec2.push_back( clock );
  sec2.push_back( timer );
  TReadoutSection sec3( "EVENT" );
  sec3.push_back( fadc );
  sec3.push_back( mm );
  event -> push_back( sec2 );
  event -> push_back( sec3 );



  // define book
  book -> AddReadoutList( runbegin );
  book -> AddReadoutList( runend );
  book -> AddReadoutList( event );



  return book;
}
