// ============================================================================
//  $Id: TRecordAssociation.cc,v 1.2 2004/03/07 10:30:27 goiwai Exp $
//  $Name: CLDAQ-1-14-03 $
//  $Log: TRecordAssociation.cc,v $
//  Revision 1.2  2004/03/07 10:30:27  goiwai
//  ROOTȤߤिΤޤʤޥᤳߤޤ
//  Ƥˤƴư櫓ǤϤޤ
//
//  Revision 1.1  2004/03/01 02:36:25  goiwai
//  RecordDisplayѤΥ饹֤ޤ.
//  ¢ˤʤäƤΤ˼ľäΤǤ,
//  ޤԽʬߤޤ.˽ƤȻפޤ.
//  DataRecord֥Ȥɽ뤿Υġ뷲ʤΤRecordDisplayȸ
//  Ǥޤ,¿ʬ˥ե饤ǤǤ.
//  饤ˤΤEventDisplay(Eventɽ)Ȥƥߥå
//  ޤ.
//
// ============================================================================
#ifdef __CLDAQ_ROOT_USE
#include "TRecordAssociation.hh"
#include "TRecordDisplayCanvas.hh"

TRecordAssociation::TRecordAssociation( const Tstring& recid, const Tstring& secid, const Tstring& segid, const Tstring& eleid, Tint nbin, Tdouble xmin, Tdouble xmax, TRecordDisplayCanvas* cv, TH1D* h )
  : theRecordID( recid ),
    theSectionID( secid ),
    theSegmentID( segid ),
    theElementID( eleid ),
    theNumberOfBins( nbin ),
    theMinimumX( xmin ),
    theMaximumX( xmax ),
    theCanvas( cv ),
    theHistogram( h ),
    theValidAssociation( Tfalse )
{
  checkValid();
}

TRecordAssociation::TRecordAssociation( const TRecordAssociation& right )
  : theRecordID( right.theRecordID ),
    theSectionID( right.theSectionID ),
    theSegmentID( right.theSegmentID ),
    theElementID( right.theElementID ),
    theNumberOfBins( right.theNumberOfBins ),
    theMinimumX( right.theMinimumX ),
    theMaximumX( right.theMaximumX ),
    theCanvas( right.theCanvas ),
    theHistogram( right.theHistogram ),
    theValidAssociation( Tfalse )
{
  checkValid();
}

TRecordAssociation::~TRecordAssociation()
{;}

const TRecordAssociation& TRecordAssociation::operator=( const TRecordAssociation& right )
{
  theRecordID = right.theRecordID;
  theSectionID = right.theSectionID;
  theSegmentID = right.theSegmentID;
  theElementID = right.theElementID;
  theNumberOfBins = right.theNumberOfBins;
  theMinimumX = right.theMinimumX;
  theMaximumX = right.theMaximumX;
  theCanvas = right.theCanvas;
  theHistogram = right.theHistogram;
  theValidAssociation = Tfalse;
  checkValid();
  return *this;
}

Tbool TRecordAssociation::operator==( const TRecordAssociation& right ) const
{
  Tbool retval = Ttrue;

  retval &= ( theRecordID == right.theRecordID );
  retval &= ( theSectionID == right.theSectionID );
  retval &= ( theSegmentID == right.theSegmentID );
  retval &= ( theElementID == right.theElementID );

  return retval;
}

Tbool TRecordAssociation::operator!=( const TRecordAssociation& right ) const
{
  Tbool retval = Tfalse;

  retval |= ( theRecordID != right.theRecordID );
  retval |= ( theSectionID != right.theSectionID );
  retval |= ( theSegmentID != right.theSegmentID );
  retval |= ( theElementID != right.theElementID );

  return retval;
}

Tostream& operator<<( Tostream& tos, const TRecordAssociation& right )
{
  //if ( right.theValidAssociation ) {
  tos << "ID: " << right.theRecordID << "/";
  tos << right.theSectionID << "/";
  tos << right.theSegmentID << "/";
  tos << right.theElementID;
  tos << ", Cv: " << right.theCanvas;
  tos << ", H1: " << right.theHistogram;
  if ( ! right.theValidAssociation ) {
    tos << " (Invalid)";
  }
  //} else {
  //tos << "invalid association";
  //}
  //tos << Tflush;
  return tos;
}

Tvoid TRecordAssociation::checkValid()
{
  theValidAssociation = Tfalse;
  if ( theRecordID.empty() || theRecordID == "" ) {
    return;
  } else if ( theSectionID.empty() || theSectionID == "" ) {
    return;
  } else if ( theSegmentID.empty() || theSegmentID == "" ) {
    return;
  } else if ( theElementID.empty() || theElementID == "" ) {
    return;
  } else if ( theNumberOfBins < 0 ) {
    return;
  } else if ( !theCanvas || !theHistogram ) {
    return;
  } else {
    theValidAssociation = Ttrue;
    return;
  }
}

#endif

#ifdef __CLDAQ_ROOT_DLL
    ClassImp(TRecordAssociation)
#endif
