// =====================================================================
//  $Id: TChangeDirectoryCommand.cc,v 1.4 2004/03/07 10:30:28 goiwai Exp $
//  $Name: CLDAQ-1-14-03 $
//  $Log: TChangeDirectoryCommand.cc,v $
//  Revision 1.4  2004/03/07 10:30:28  goiwai
//  ROOTȤߤिΤޤʤޥᤳߤޤ
//  Ƥˤƴư櫓ǤϤޤ
//
//  Revision 1.3  2003/10/06 17:02:37  goiwai
//  *** empty log message ***
//
//  Revision 1.2  2003/07/30 16:17:30  goiwai
//  ե˥ߥåȥĤ뤳Ȥˤޤ.
//
// =====================================================================
#include "TChangeDirectoryCommand.hh"
#include "TRunManager.hh"
#include "TUserInterface.hh"

static const Tstring _name = "cd";
static const Tstring _desc = "change the current directory.";

TChangeDirectoryCommand::TChangeDirectoryCommand( TRunManager* manager )
  : TCommand( manager, _name, _desc )
{;}

TChangeDirectoryCommand::~TChangeDirectoryCommand()
{;}

Tvoid TChangeDirectoryCommand::Execute( const TstringList& arguments )
{
  TUserInterface* ui = theRunManager -> GetUserInterface();
  if ( ui == 0 ) {
    return;
  }

  if ( arguments.empty() ) {
    ui -> SetCurrentWorkingDirectory( "/" );
  } else if ( arguments.size() == 1 ) {
    ui -> SetCurrentWorkingDirectory( arguments[ 0 ] );
  } else {
    Tcerr << "TChangeDirectoryCommand::Execute: Too many arguments." << Tendl;
  }
  return;
}

#ifdef __CLDAQ_ROOT_DLL
    ClassImp(TChangeDirectoryCommand)
#endif
