// =====================================================================
/*!
//
//  \file TCamacScalerModule.hh
//  \brief This file contains the TCamacScalerModule class.
//  \author Go IWAI <goiwai@users.sourceforge.jp>
//
//  $Id: TCamacScalerModule.hh,v 1.6 2004/03/07 10:30:31 goiwai Exp $
//  $Name: CLDAQ-1-14-03 $
//  $Log: TCamacScalerModule.hh,v $
//  Revision 1.6  2004/03/07 10:30:31  goiwai
//  ROOTȤߤिΤޤʤޥᤳߤޤ
//  Ƥˤƴư櫓ǤϤޤ
//
//  Revision 1.5  2004/01/19 21:09:41  goiwai
//  ץץåƬCLDAQ__ѹޤ.
//
//  Revision 1.4  2003/11/03 08:35:13  goiwai
//  DoxygenѤΥȥȤ򤦤Ǥߤ򳫻Ϥޤ.
//
//  Revision 1.3  2003/10/06 17:02:40  goiwai
//  *** empty log message ***
//
//  Revision 1.2  2003/07/30 16:19:10  goiwai
//  ե˥ߥåȥĤ뤳Ȥˤޤ.
//
*/
// =====================================================================
#ifndef CLDAQ__TCAMACSCALERMODULE_HH
#define CLDAQ__TCAMACSCALERMODULE_HH

#include "Tglobals.h"
#include "TCamacModule.hh"

class TDataSegment;
class TDataElement;


/*!
// \example
//
// If example code exists.
//
*/

/*!
// \class TCamacScalerModule
// \brief This is the TCamacScalerModule class.
// \author Go IWAI <goiwai@users.sourceforge.jp>
//
// The TCamacScalerModule class detail description.
// Write it down ASAP!
//
// \todo None?
// \bug None?
// \ingroup ModulesCategory
*/
class TCamacScalerModule
  : public TCamacModule
{

  public:
    TCamacScalerModule( TCamacCrateController* cc7x00, Tint slot, Tint nch = 12, Tdata_t datalen = t24bitModule );
    TCamacScalerModule( const TCamacScalerModule& right );
    ~TCamacScalerModule();

  public:
    const TCamacScalerModule& operator=( const TCamacScalerModule& right );
    Tbool operator==( const TCamacScalerModule& right ) const;
    Tbool operator!=( const TCamacScalerModule& right ) const;
    Tvoid FillData( TDataElement& element, Tint channel );

  public:
    Tint Clear();
    Tint Update();
    Tint Initialize();

  public:
    Tint ReadOverflowChannel();
    Tint ClearOverflowChannel();
    Tint IncrementAllChannel();

#ifdef __CLDAQ_ROOT_DLL
    ClassDef(TCamacScalerModule,0)
#endif

};

#endif
