// =====================================================================
/*!
//
//  \file TReadoutBook.hh
//  \brief This file contains the TReadoutBook class.
//  \author Go IWAI <goiwai@users.sourceforge.jp>
//
//  $Id: TReadoutBook.hh,v 1.6 2004/03/07 10:30:33 goiwai Exp $
//  $Name: CLDAQ-1-14-03 $
//  $Log: TReadoutBook.hh,v $
//  Revision 1.6  2004/03/07 10:30:33  goiwai
//  ROOTȤߤिΤޤʤޥᤳߤޤ
//  Ƥˤƴư櫓ǤϤޤ
//
//  Revision 1.5  2004/01/19 21:09:42  goiwai
//  ץץåƬCLDAQ__ѹޤ.
//
//  Revision 1.4  2003/11/03 08:35:14  goiwai
//  DoxygenѤΥȥȤ򤦤Ǥߤ򳫻Ϥޤ.
//
//  Revision 1.3  2003/10/06 16:39:00  goiwai
//  *** empty log message ***
//
//  Revision 1.2  2003/07/30 16:20:11  goiwai
//  ե˥ߥåȥĤ뤳Ȥˤޤ.
//
*/
// =====================================================================
#ifndef CLDAQ__TREADOUTBOOK_HH
#define CLDAQ__TREADOUTBOOK_HH

#include "Tglobals.h"
#include "TReadoutIndex.hh"

class TReadoutList;
class TDataRecord;


/*!
// \example
//
// If example code exists.
//
*/

/*!
// \class TReadoutBook
// \brief This is the TReadoutBook class.
// \author Go IWAI <goiwai@users.sourceforge.jp>
//
// The TReadoutBook class detail description.
// Write it down ASAP!
//
// \todo None?
// \bug None?
// \ingroup ReadoutCategory
*/
class TReadoutBook
{

  private:
    TReadoutIndex theReadoutIndex;

  public:
    TReadoutBook();
    ~TReadoutBook();

  public:
    const TReadoutIndex& GetReadoutIndex() const;
    TReadoutIndex& GetReadoutIndex();
    Tvoid SetReadoutIndex( const TReadoutIndex& index );

  public:
    Tint AddReadoutList( TReadoutList* readoutlist );
    Tint RemoveReadoutList( Tint index );
    Tint RemoveReadoutList( const Tstring& id );
    Tvoid ClearReadoutBook();
    TReadoutList* FindReadoutList( const Tstring& id );
    TReadoutList* GetReadoutList( Tint index );
    TReadoutList* GetReadoutList( const Tstring& id );
    TDataRecord Read( const Tstring& id );

#ifdef __CLDAQ_ROOT_DLL
    ClassDef(TReadoutBook,0)
#endif

};

inline const TReadoutIndex& TReadoutBook::GetReadoutIndex() const
{
  return theReadoutIndex;
}

inline TReadoutIndex& TReadoutBook::GetReadoutIndex()
{
  return theReadoutIndex;
}

inline Tvoid TReadoutBook::SetReadoutIndex( const TReadoutIndex& index )
{
  theReadoutIndex = index;
  return;
}

#endif
