// =====================================================================
//  $Id: TReadoutSection.cc,v 1.4 2004/03/07 10:30:33 goiwai Exp $
//  $Name: CLDAQ-1-14-03 $
//  $Log: TReadoutSection.cc,v $
//  Revision 1.4  2004/03/07 10:30:33  goiwai
//  ROOTȤߤिΤޤʤޥᤳߤޤ
//  Ƥˤƴư櫓ǤϤޤ
//
//  Revision 1.3  2003/10/06 16:39:00  goiwai
//  *** empty log message ***
//
//  Revision 1.2  2003/07/30 16:20:11  goiwai
//  ե˥ߥåȥĤ뤳Ȥˤޤ.
//
// =====================================================================
#include "TReadoutSection.hh"
#include "TDataSection.hh"

TReadoutSection::TReadoutSection( const Tstring& id )
  : TReadoutIdentification( id ), TReadoutSegmentList()
{;}

TReadoutSection::TReadoutSection( const TReadoutSection& right )
  : TReadoutIdentification( right ), TReadoutSegmentList( right )
{;}

TReadoutSection::~TReadoutSection()
{;}

TDataSection TReadoutSection::Read()
{
  TDataSection section( theID );

  for ( Tsize_t i = 0; i < size(); i ++ ) {
    section.push_back( ( (*this)[ i ] ).Read() );
  }

  return section;
}

const TReadoutSection& TReadoutSection::operator=( const TReadoutSection& right )
{
  *( (TReadoutIdentification*)this ) = *( (TReadoutIdentification*)(&right) );
  *( (TReadoutSegmentList*)this ) = *( (TReadoutSegmentList*)(&right) );
  return *this;
}

Tbool TReadoutSection::operator==( const TReadoutSection& right ) const
{
  Tbool ret = Ttrue;
  ret &= ( *( (TReadoutIdentification*)this ) == *( (TReadoutIdentification*)(&right) ) );
  ret &= ( *( (TReadoutSegmentList*)this ) == *( (TReadoutSegmentList*)(&right) ) );
  return ret;
}

Tbool TReadoutSection::operator!=( const TReadoutSection& right ) const
{
  Tbool ret = Tfalse;
  ret |= ( *( (TReadoutIdentification*)this ) != *( (TReadoutIdentification*)(&right) ) );
  ret |= ( *( (TReadoutSegmentList*)this ) != *( (TReadoutSegmentList*)(&right) ) );
  return ret;
}

#ifdef __CLDAQ_ROOT_DLL
    ClassImp(TReadoutSection)
#endif
