// =====================================================================
//  $Id: ifile.cc,v 1.4 2003/10/12 13:07:53 goiwai Exp $
//  $Name: CLDAQ-1-14-03 $
//  $Log: ifile.cc,v $
//  Revision 1.4  2003/10/12 13:07:53  goiwai
//  㴳ν
//
//  Revision 1.3  2003/10/06 04:03:39  goiwai
//  TArgumentѤ褦ƤΥץޤ.
//
//  Revision 1.2  2003/07/30 16:21:38  goiwai
//  ե˥ߥåȥĤ뤳Ȥˤޤ.
//
// =====================================================================
#include "TDataRecord.hh"
#include "TInputObjectFile.hh"
#include "TBenchmark.hh"
#include "TArgument.hh"

int main( int argc, char** argv, char** envv )
{
  TArgument arg( argc, argv );
  if ( arg.GetNumberOfElements() != 1 || !isexist( arg[ 0 ] ) ) {
    arg.ShowUsage();
  }
  const Tstring filename = arg[ 0 ];
 
  TInputObjectFile ifile( filename );
  Tint nevents = 0;
  Tint datasize = 0;

  TDataRecord record;
  TBenchmark bench;
  bench.Start();
  while ( ifile.Read( record ) ) {
    datasize += record.GetRecordSize();
    nevents ++;
  }
  bench.Stop();
  Tcout << bench << Tendl;

  Tcout << nevents << " events, ";
  Tcout << datasize << Tslash << ifile.GetTotalDataSize();
  Tcout << " byte data has been read from " << filename << "." << Tendl;

  return 0;
}
