// =====================================================================
//  $Id: mm7702.cc,v 1.4 2003/10/06 04:03:39 goiwai Exp $
//  $Name: CLDAQ-1-14-03 $
//  $Log: mm7702.cc,v $
//  Revision 1.4  2003/10/06 04:03:39  goiwai
//  TArgumentѤ褦ƤΥץޤ.
//
//  Revision 1.3  2003/07/30 16:21:39  goiwai
//  ե˥ߥåȥĤ뤳Ȥˤޤ.
//
// =====================================================================
#include "TRs232cKeithley7702Module.hh"
#include "TDataElement.hh"
#include "TBenchmark.hh"
#include "TOption.hh"
#include "TOptionTable.hh"
#include "TArgument.hh"

int main( int argc, char** argv, char** envv )
{
  TOption opevent( "number-of-events", 1 );
  TOption opdevice( "device", "d", 1, "/dev/ttyS0 is typical on linux system" );
  const Tint noption = 2;
  TOption options[ noption ] = { opevent, opdevice };
  TArgument arg( argc, argv, TOptionTable( options, noption ) );

  Tstring devpath = "/dev/ttyS0";
  if ( arg.HasOption( opdevice ) ) {
    devpath = arg[ opdevice ];
  }

  Tint nevent = 10;
  if ( arg.HasOption( opevent ) ) {
    nevent = arg.GetIntegerParameter( opevent );
  }

  const Tint nchannel = 32;
  TRs232cKeithley7702Module mm7702;
  mm7702.Initialize();
  TDataElement e;

  TBenchmark bench;
  bench.Start();
  for ( Tint i = 0; i < nevent; i ++ ) {
    for ( Tint i = 0; i < nchannel; i ++ ) {
      e.SetID( itostr( i, 0 ) );
      mm7702.FillData( e, i );
      Tcout << e << Tendl;
    }
    mm7702.Clear();
  }
  mm7702.Close();
  bench.Stop();
  Tcout << bench << Tendl;

  return 0;
}
