// =====================================================================
//  $Id: OFFsubplot.cc,v 1.3 2003/10/06 16:28:18 goiwai Exp $
//  $Name: CLDAQ-1-14-06 $
//  $Log: OFFsubplot.cc,v $
//  Revision 1.3  2003/10/06 16:28:18  goiwai
//  *** empty log message ***
//
//  Revision 1.2  2003/07/30 16:16:10  goiwai
//  ե˥ߥåȥĤ뤳Ȥˤޤ.
//
// =====================================================================
#include "TDataRecord.hh"
#include "TDataSection.hh"
#include "TDataElement.hh"
#include "TInputObjectFile.hh"
#include "Trootinit.h"

#include "St01DataRecordConversion.hh"

int main( int argc, char** argv, char** envv )
{
  if ( argc != 2 ) {
    Tcerr << "usage: " << argv[ 0 ] << Tspace << "<filename>" << Tendl;
    return -1;
  }

  TApplication* theApplication = rootinit();
  TCanvas cv( "CVfadc", "Pentland MPX201A" );
  TH1D mpx201a( "mpx201a", "subtracted H.O.C", 500, -1000.0, 4096.0 );
  //mpx201a.SetFillColor( 45 );


  St01DataRecordConversion conversion;
  TDataRecord r;
  Tstring ifname = argv[ 1 ];
  TInputObjectFile ifile( ifname );
  while ( ( ifile >> r ) != 0 ) {
    TDataMultiplicity& map = conversion.Convert( r );
    if ( conversion.IsSuccess() ) {
      for ( Tint row = 0; row < map.num_row(); row ++ ) {
	for ( Tint col = 0; col < map.num_col(); col ++ ) {
	  mpx201a.Fill( map[ row ][ col ] );
	} 
      }
    }
  }

  cv.cd();
  mpx201a.Draw();
  theApplication -> Run();

  return 0;
}
