// =====================================================================
//  $Id: St01DarkViewCommand.cc,v 1.5 2003/10/06 16:28:18 goiwai Exp $
//  $Name: CLDAQ-1-14-06 $
//  $Log: St01DarkViewCommand.cc,v $
//  Revision 1.5  2003/10/06 16:28:18  goiwai
//  *** empty log message ***
//
//  Revision 1.4  2003/07/30 16:16:11  goiwai
//  ե˥ߥåȥĤ뤳Ȥˤޤ.
//
// =====================================================================
#include "TRunManager.hh"
#include "TUserInterface.hh"
#include "TOutputObjectFile.hh"
#include "TEnvironmentVariableTable.hh"

#include "St01DarkViewCommand.hh"
#include "St01RunAction.hh"

static const Tstring _name = "/local/st01darkview";
static const Tstring _desc = "view histograms in DARK run.";

St01DarkViewCommand::St01DarkViewCommand()
  : TCommand( _name, _desc )
{;}

St01DarkViewCommand::~St01DarkViewCommand()
{;}

Tvoid St01DarkViewCommand::Execute( const TstringList& arguments )
{
  const TEnvironmentVariableTable& envtable = 
    theRunManager -> GetEnvironmentVariableTable();
  Tstring bindir = envtable.GetEnvironmentValue( "ST01_BIN_DIR" );

  TstringList args;
  Tstring comname = bindir + Tslash + "st01darkview";
  Tstring runid = theRunManager -> GetRun().GetStringRunID();

  args.push_back( comname );
  args.push_back( runid );
  args.push_back( "&" );

  TUserInterface* ui = theRunManager -> GetUserInterface();
  Tstring com = "/system/shell";
  ui -> ExecuteCommand( com, args );

  return;
}
