// =====================================================================
/*!
//
//  \file TDataSegment.hh
//  \brief This file contains the TDataSegment class.
//  \author Go IWAI <goiwai@users.sourceforge.jp>
//
//  $Id: TDataSegment.hh,v 1.10 2004/03/07 10:30:30 goiwai Exp $
//  $Name: CLDAQ-1-14-06 $
//  $Log: TDataSegment.hh,v $
//  Revision 1.10  2004/03/07 10:30:30  goiwai
//  ROOTȤߤिΤޤʤޥᤳߤޤ
//  Ƥˤƴư櫓ǤϤޤ
//
//  Revision 1.9  2004/01/19 21:09:39  goiwai
//  ץץåƬCLDAQ__ѹޤ.
//
//  Revision 1.8  2003/12/06 10:59:11  goiwai
//  Serialize(Tvoid*) -> Serialize(const Tvoid*)ѹޤ.
//  Deserialize(const Tvoid*)ɲäޤ.
//  ȴμʤΤ,ХåեСեβǽޤ.
//  Reallocate()Ȥ褦ʻȤߤɬפǤ.
//
//  Revision 1.7  2003/11/24 06:56:49  goiwai
//  Size()дؿɲäޤ.
//  ƤDataElementο֤ޤ.
//
//  Revision 1.6  2003/11/04 12:03:05  goiwai
//  ==黻Ҥ!=黻Ҥޤ.Ūˤ
//  if ( record == "String" ) {
//    hoeghoge;
//  }
//  Τ褦ʻȤޤ.ñ theID ФȤӤƷ̤֤ޤ.
//
//  Revision 1.5  2003/11/03 08:35:12  goiwai
//  DoxygenѤΥȥȤ򤦤Ǥߤ򳫻Ϥޤ.
//
//  Revision 1.4  2003/10/06 16:42:19  goiwai
//  *** empty log message ***
//
//  Revision 1.3  2003/08/25 09:21:44  goiwai
//  operator[]( const Tstring& id ) äޤ.
//  segment[0] Ȥ segment["tag"] Ȥ, TDataElement 뤳Ȥ
//  ޤ.
//  size()ۤϰϤˤ,åʤǥޤ.
//  ޥåʤäޤ.
//  Ʊ̾ǥ줿 DataElement ,ǽ˥ޥåΤ֤
//  Ƥޤ.
//
//  Revision 1.2  2003/07/30 16:17:51  goiwai
//  ե˥ߥåȥĤ뤳Ȥˤޤ.
//
*/
// =====================================================================
#ifndef CLDAQ__TDATASEGMENT_HH
#define CLDAQ__TDATASEGMENT_HH

#include "Tglobals.h"
#include "TStreamableObject.hh"
#include "TDataElementList.hh"

class TOutputObjectStream;
class TOutputObjectFile;
class TOutputObjectSocket;
class TOutputObjectSharedMemory;


/*!
// \example
//
// If example code exists.
//
*/

/*!
// \class TDataSegment
// \brief This is the TDataSegment class.
// \author Go IWAI <goiwai@users.sourceforge.jp>
//
// The TDataSegment class detail description.
// Write it down ASAP!
//
// \todo None?
// \bug None?
// \ingroup DatarecordCategory
*/
class TDataSegment
  : public TStreamableObject, public TDataElementList
{

  public:
    TDataSegment( const Tstring& id = TunknownID );
    TDataSegment( const TDataSegment& right );
    ~TDataSegment();

  public:
    Tint GetRecordSize();
    Tint Record( TOutputObjectStream* output );
    Tvoid Clear();
    Tint Serialize( const Tvoid* buffer );
    Tint Deserialize( const Tvoid* buffer );
    Tint Size() const;

  public:
    const TDataSegment& operator=( const TDataSegment& right );
    Tbool operator==( const TDataSegment& right ) const;
    Tbool operator!=( const TDataSegment& right ) const;
    Tbool operator==( const Tstring& right ) const;
    Tbool operator!=( const Tstring& right ) const;
    const TDataElement& operator[]( Tint n ) const;
    TDataElement& operator[]( Tint n );
    const TDataElement& operator[]( const Tstring& id ) const;
    TDataElement& operator[]( const Tstring& id );
    friend Tostream& operator<<( Tostream& tos, const TDataSegment& right );

  public:
    Tbool FindDataElement( const Tstring& id, TDataElement& element ) const;
    Tint FindDataElement( const Tstring& id ) const;

  private:
    Tint record( TOutputObjectFile* ofile );
    Tint record( TOutputObjectSocket* osocket );
    Tint record( TOutputObjectSharedMemory* omemory );

#ifdef __CLDAQ_ROOT_DLL
    ClassDef(TDataSegment,0)
#endif

};

inline Tint TDataSegment::Size() const
{
  return (Tint)size();
}

#endif
