// =====================================================================
//  $Id: TRs232cKeithley7702Module.cc,v 1.5 2004/03/07 10:30:31 goiwai Exp $
//  $Name: CLDAQ-1-14-06 $
//  $Log: TRs232cKeithley7702Module.cc,v $
//  Revision 1.5  2004/03/07 10:30:31  goiwai
//  ROOTȤߤिΤޤʤޥᤳߤޤ
//  Ƥˤƴư櫓ǤϤޤ
//
//  Revision 1.4  2003/10/06 17:02:40  goiwai
//  *** empty log message ***
//
//  Revision 1.3  2003/07/30 16:19:11  goiwai
//  ե˥ߥåȥĤ뤳Ȥˤޤ.
//
// =====================================================================
#include "TRs232cKeithley7702Module.hh"

TRs232cKeithley7702Module::TRs232cKeithley7702Module( const Tstring devfile, Tint nchannel )
  : TRs232cModule( devfile, nchannel )
{;}

TRs232cKeithley7702Module::TRs232cKeithley7702Module( Tint nchannel, Tstring devfile )
  : TRs232cModule( nchannel, devfile )
{;}

TRs232cKeithley7702Module::TRs232cKeithley7702Module( const TRs232cKeithley7702Module& right )
  : TRs232cModule( right )
{;}

TRs232cKeithley7702Module::~TRs232cKeithley7702Module()
{;}

Tvoid TRs232cKeithley7702Module::defineClearMethod( Tint channel )
{
  if ( channel != 0 ) {
    return;
  }

  //顼塼򥯥ꥢ
  Write( "*CLS" );
  return;
}

Tvoid TRs232cKeithley7702Module::defineUpdateMethod( Tint channel )
{
  if ( channel != 0 ) {
    return;
  }

  Clear();
  return;
}

Tvoid TRs232cKeithley7702Module::defineInitializeMethod( Tint channel )
{
  if ( channel != 0 ) {
    return;
  }

  //ǥե᤹
  Write( ":SYST:PRES" );
  Write( "*RST" );
  Write( "*CLS" );

  //BEEP OFF
  //Write( ":SYST:BEEP OFF" );

  //󥵤μ󥰥륯ȤǤޤͤФʤʤ
  //Write( ":SENS:FUNC 'RES'" );

  //ʬ®٤PLCñ̤
  //Write( ":SENS:RES:NPLC 1" );

  //ʬ®٤ñ̤
  //Write( ":SENS:RES:APER 1" );

  //ؤ
  //Write( "SENS:RES:RANG 120e6" );

  //
  //Write( "SENS:RES:DIG 5" );

  //AUTOON
  //Write( "SENS:RES:RANG:AUTO ON" );
  Write( "SENS:VOLT:RANG:AUTO OFF, (@101:132)" );

  //ǡǻ
  Write( ":FORM:ELEM READ" );

  return;
}

Tvoid TRs232cKeithley7702Module::defineReadMethod( Tint channel )
{
  Tstring strch = itostr( channel + 1, 2 );
  Tstring command = ":ROUT:CLOS (@1" + strch + ")";
  Write( command );
  Write( ":READ?" );
  return;
}

Tbool TRs232cKeithley7702Module::modifyData( const Tstring& accept, Tdouble& databuf ) const
{
  databuf = strtod( accept.c_str(), 0 );
  return Ttrue;
}

#ifdef __CLDAQ_ROOT_DLL
    ClassImp(TRs232cKeithley7702Module)
#endif
