// =====================================================================
//  $Id: serialize.cc,v 1.1 2003/12/06 11:06:22 goiwai Exp $
//  $Name: CLDAQ-1-14-06 $
//  $Log: serialize.cc,v $
//  Revision 1.1  2003/12/06 11:06:22  goiwai
//  ǡ쥳ɤΥꥢ饤ǽΥƥ.
//  ȥ꡼ޥ֥륪֥Ȥòե륳ԡǤ.
//
// =====================================================================
#include "TInputObjectFile.hh"
#include "TBenchmark.hh"
#include "TDataRecord.hh"
#include "TOption.hh"
#include "TOptionTable.hh"
#include "TArgument.hh"

int main( int argc, char** argv, char** envv )
{
  TArgument arg( argc, argv );
  if ( arg.GetNumberOfElements() != 2 ) {
    arg.ShowUsage();
  }
  const Tstring ifname = arg.GetElement( 0 );
  const Tstring ofname = arg.GetElement( 1 );

  TInputObjectFile ifile( ifname );
  Tofstream ofs( ofname.c_str() );

  const Tint buflen = 0x10000;
  Tbyte buffer[ buflen ]; 

  TDataRecord record;
  TBenchmark bench;
  bench.Start();
  while ( ifile.Read( record ) ) {
    Tint retval = record.Serialize( buffer );
    ofs.write( (Tchar*)buffer, retval );
  }
  ofs.close();
  bench.Stop();
  Tcout << bench << Tendl;

  return 0;
}
