// =====================================================================
//  $Id: Rs01ViewCommand.cc,v 1.4 2003/07/08 00:55:15 goiwai Exp $
//  $Name: CLDAQ-1-06-00 $
// =====================================================================
#include "TRunManager.hh"
#include "TUserInterface.hh"
#include "TOutputObjectFile.hh"
#include "TEnvironmentVariableTable.hh"

#include "Rs01ViewCommand.hh"
#include "Rs01RunAction.hh"

static const Tstring _name = "/local/rs01view";
static const Tstring _desc = "KEITHLEY Multimeter Model 2700 with 7702";

Rs01ViewCommand::Rs01ViewCommand()
  : TCommand( _name, _desc )
{;}

Rs01ViewCommand::~Rs01ViewCommand()
{;}

Tvoid Rs01ViewCommand::Execute( const TstringList& arguments )
{
  const TEnvironmentVariableTable& envtable =
    theRunManager -> GetEnvironmentVariableTable();
  Tstring bindir = envtable.GetEnvironmentValue( "RS01_BIN_DIR" );

  TstringList args;
  Tstring comname = bindir + Tslash + "rs01view";
  Tint runid = theRunManager -> GetRun().GetRunID();

  args.push_back( comname );
  args.push_back( itostr( runid, 0 ) );
  args.push_back( "&" );

  TUserInterface* ui = theRunManager -> GetUserInterface();
  Tstring com = "/system/shell";
  ui -> ExecuteCommand( com, args );

  return;
}
