// =====================================================================
//  $Id: St00DataRecordConversion.cc,v 1.1.1.1 2003/06/27 02:56:41 goiwai Exp $
//  $Name: CLDAQ-1-06-00 $
// =====================================================================
#include "St00DataRecordConversion.hh"
#include "TDataRecord.hh"
#include "TDataElement.hh"

St00DataRecordConversion::St00DataRecordConversion()
  : St00Map( "" ), theConversionSuccess( Tfalse )
{;}

St00DataRecordConversion::~St00DataRecordConversion()
{;}

TDataMultiplicity& St00DataRecordConversion::Convert( const TDataRecord& record )
{
  Tstring fadcidset[ 3 ] = { "EVENT", "ADC", "0" };
  TDataElement e;
  if ( record.FindDataElement( fadcidset, e ) ) {
    Tshort* data = e.GetShortData();
    Tint ndata = e.GetNumberOfPrimitives();
    FillMap( data, ndata );
    theConversionSuccess = Ttrue;
  } else {
    theConversionSuccess = Tfalse;
  }

  return( theMap );
}
