// =====================================================================
//  $Id: St00OfflineRmsMap.cc,v 1.1.1.1 2003/06/27 02:56:41 goiwai Exp $
//  $Name: CLDAQ-1-06-00 $
// =====================================================================
#include "St00OfflineRmsMap.hh"
#include "St00OfflineDarkAverageMap.hh"
#include "TDataRecord.hh"
#include "TDataSection.hh"
#include "TDataSegment.hh"
#include "TDataElement.hh"
#include "TDataMultiplicity.hh"
#include "TInputObjectFile.hh"

St00OfflineRmsMap::St00OfflineRmsMap( const Tstring& filename )
  : St00Map( filename ), theOfflineDarkAverageMap( theInputFileName )
{
  const TDataMultiplicity& avemap = theOfflineDarkAverageMap.GetMap();

  Tstring fadcidset[ 3 ] = { "EVENT", "ADC", "0" };
  TInputObjectFile ifile( theInputFileName );
  TDataRecord r;
  Tint nframe = 0;

  TDataMultiplicity mapbuf( theNumberOfVerticalPixels, theNumberOfHorizontalPixels, 0 );
  TDataMultiplicity diff( theNumberOfVerticalPixels, theNumberOfHorizontalPixels, 0 );

  while ( ( ifile >> r ) != 0 ) {
    TDataElement e;
    if ( r.FindDataElement( fadcidset, e ) ) {
      Tshort* data = e.GetShortData();
      Tint ndata = e.GetNumberOfPrimitives();
      FillMap( data, ndata );
      diff = theMap - avemap;
      for ( Tint row = 0; row < diff.num_row(); row ++ ) {
	for ( Tint col = 0; col < diff.num_col(); col ++ ) {
	  diff[ row ][ col ] = pow( diff[ row ][ col ], 2.0 );
	}
      }
      mapbuf += diff;
      nframe ++;
    } else {
      continue;
    }
  }

  theMap = mapbuf / nframe;

  for ( Tint row = 0; row < theMap.num_row(); row ++ ) {
    for ( Tint col = 0; col < theMap.num_col(); col ++ ) {
      theMap[ row ][ col ] = sqrt( theMap[ row ][ col ] );
    }
  }

}

St00OfflineRmsMap::~St00OfflineRmsMap()
{;}
