// =====================================================================
//  $Id: St00RunSummary.cc,v 1.1.1.1 2003/06/27 02:56:41 goiwai Exp $
//  $Name: CLDAQ-1-06-00 $
// =====================================================================
#include "TRunInformationList.hh"
#include "TRunInformation.hh"
#include "St00RunSummary.hh"

St00RunSummary::St00RunSummary()
  : theRunID( 0 ), 
    theRecordName(), 
    theRecordSize( 0 ), 
    theNumberOfEvents( 0 ), 
    theRunInformationTable(),
    theRunBeginTime(),
    theRunEndTime()
{;}

St00RunSummary::~St00RunSummary()
{;}

Tvoid St00RunSummary::Initialize()
{
  theRunID = 0;
  theRecordName.erase();
  theRecordSize = 0;
  theNumberOfEvents = 0; 
  theRunInformationTable.Clear();
  theRunBeginTime.erase();
  theRunEndTime.erase();
  return;
}

TRunInformationTable St00RunSummary::GenerateRunSummaryTable() const
{
  TRunInformationList infolist;
  infolist.push_back( TRunInformation( "RUN ID", itostr( theRunID ) ) );
  infolist.push_back( TRunInformation( "RECORD PATH", theRecordName ) );
  infolist.push_back( TRunInformation( "RECORD SIZE", itostr( theRecordSize ) ) );
  infolist.push_back( TRunInformation( "RUN BEGIN", theRunBeginTime ) );
  infolist.push_back( TRunInformation( "RUN END", theRunEndTime ) );
  infolist.push_back( TRunInformation( "EVENTS", itostr( theNumberOfEvents ) ) );
  return( theRunInformationTable + infolist );
}
