// =====================================================================
//  $Id: St01RunInformationExtractor.hh,v 1.1 2003/06/27 19:16:43 goiwai Exp $
//  $Name: CLDAQ-1-06-00 $
// =====================================================================
#ifndef __ST01RUNINFORMATIONEXTRACTOR_HH
#define __ST01RUNINFORMATIONEXTRACTOR_HH

#include "Tglobals.h"

class St01RunInformationExtractor
{

  private:
    Tstring theRecordPath;
    TstringList theElementTags;
    TstringList theElements;

  public:
    St01RunInformationExtractor( const Tstring& recpath );
    ~St01RunInformationExtractor();

  public:
    friend Tostream& operator<<( Tostream& tos, const St01RunInformationExtractor& right );

  public:
    const Tstring& GetRecordPath() const;
    const TstringList& GetElementTags() const;
    const TstringList& GetElements() const;
    const Tstring& GetElementTag( Tint index ) const;
    const Tstring& GetElement( Tint index ) const;

};

inline const Tstring& St01RunInformationExtractor::GetRecordPath() const
{
  return( theRecordPath );
}

inline const TstringList& St01RunInformationExtractor::GetElementTags() const
{
  return( theElementTags );
}

inline const TstringList& St01RunInformationExtractor::GetElements() const
{
  return( theElements );
}

inline const Tstring& St01RunInformationExtractor::GetElementTag( Tint index ) const
{
  return( theElementTags[ index ] );
}

inline const Tstring& St01RunInformationExtractor::GetElement( Tint index ) const
{
  return( theElements[ index ] );
}

#endif
