// =====================================================================
//  $Id: TShellCommand.cc,v 1.1.1.1 2003/06/27 02:56:41 goiwai Exp $
//  $Name: CLDAQ-1-06-00 $
// =====================================================================
#include "TShellCommand.hh"

static const Tstring _name = "/system/shell";
static const Tstring _desc = "execute shell command.\nexample> shell ls -l\nexample> /system/shell ps aux";

TShellCommand::TShellCommand( TRunManager* manager )
  : TCommand( manager, _name, _desc )
{;}

TShellCommand::~TShellCommand()
{;}

Tvoid TShellCommand::Execute( const TstringList& arguments )
{
  if ( arguments.empty() ) {
    ShowCommandDetail();
    return;
  }

  Tstring shcom;
  for ( Tsize_t i = 0; i < arguments.size(); i ++ ) {
    shcom += arguments[ i ];
    if ( i != arguments.size() - 1 )
      shcom += Tspace;
  }
  system( shcom.c_str() );

  return;
}
