// =====================================================================
//  $Id: TCamacModule.cc,v 1.1.1.1 2003/06/27 02:56:41 goiwai Exp $
//  $Name: CLDAQ-1-06-00 $
// =====================================================================
#include "TCamacModule.hh"
#include "TCamacCrateController.hh"

TCamacModule::TCamacModule( TCamacCrateController* cc7x00, Tint slot, Tint nch, Tdata_t datalen )
  : TModule( nch ),
    theCrateController( cc7x00 ), theDataLength( datalen ),
    theSlotNumber( slot ), theQ( 0 ), theX( 0 ), theCamacData( 0 )
{;}

TCamacModule::TCamacModule( const TCamacModule& right )
  : TModule( right ),
    theCrateController( right.theCrateController ),
    theDataLength( right.theDataLength ), 
    theSlotNumber( right.theSlotNumber ), 
    theQ( 0 ), theX( 0 ), theCamacData( 0 )
{;}

TCamacModule::~TCamacModule()
{;}

const TCamacModule& TCamacModule::operator=( const TCamacModule& right )
{
  *( (TModule*)this ) = *( (TModule*)(&right) );
  theCrateController = right.theCrateController;
  theDataLength = right.theDataLength;
  theSlotNumber = right.theSlotNumber;
  theQ = right.theQ;
  theX = right.theX;
  theCamacData = right.theCamacData;
  return( *this );
}

Tbool TCamacModule::operator==( const TCamacModule& right ) const
{
  Tbool retval = Ttrue;
  retval &= ( *( (TModule*)this ) == *( (TModule*)(&right) ) );
  retval &= ( theCrateController == right.theCrateController );
  retval &= ( theSlotNumber == right.theSlotNumber );
  retval &= ( theDataLength == right.theDataLength );;
  return( retval );
}

Tbool TCamacModule::operator!=( const TCamacModule& right ) const
{
  Tbool retval = Tfalse;
  retval |= ( *( (TModule*)this ) != *( (TModule*)(&right) ) );
  retval |= ( theCrateController != right.theCrateController );
  retval |= ( theSlotNumber != right.theSlotNumber );
  retval |= ( theDataLength != right.theDataLength );;
  return( retval );
}

Tint TCamacModule::WaitInterrupt( Tint msec )
{
  TUint timeout = (TUint)( (Tdouble)HZ/(Tdouble)1000 * (Tdouble)msec );
  TUint mask = ( 1 << ( theSlotNumber  - 1 ) );
  TUint buffer[ 2 ] = { timeout, ~mask };

  errno ^= errno;
  ioctl( theCrateController -> GetFileDescriptor(), IOC_WAIT_LAM, &buffer );
  theStatus = -errno;
  theCrateController -> SetStatus( theStatus );

  return( theStatus );
}

Tint TCamacModule::ReadInterrupt()
{
  errno ^= errno;
  ioctl( theCrateController -> GetFileDescriptor(), IOC_GET_LAM, &theCamacData );
  theStatus = -errno;
  theCrateController -> SetStatus( theStatus );

  return( theStatus );
}

Tint TCamacModule::Clear()
{
  return( execute( 0, tCamacClear ) );
}

Tint TCamacModule::Update()
{
  return( Clear() );
}

Tint TCamacModule::Initialize()
{
  Clear();
  return( DisableInterrupt() );
}

Tint TCamacModule::TestInterrupt()
{
  return( execute( 0, tCamacTestInterrupt ) );
}

Tint TCamacModule::ClearInterrupt()
{
  return( execute( 0, tCamacClearInterrupt ) );
}

Tint TCamacModule::EnableInterrupt()
{
  return( execute( 0, tCamacEnableInterrupt ) );
}

Tint TCamacModule::DisableInterrupt()
{
  return( execute( 0, tCamacDisableInterrupt ) );
}

Tint TCamacModule::Read()
{
  return( execute( 0, tCamacRead ) );
}

Tint TCamacModule::Read( Tint subaddress )
{
  return( execute( subaddress, tCamacRead ) );
}

Tint TCamacModule::Write( Tint data )
{
  theCamacData = (TUint)data;
  return( execute( 0, tCamacWrite ) );
}

TUint TCamacModule::generateNAF( Tint n, Tint a, Tint f )
{
  TUint naf = 0L;
  if ( theCrateController -> IsISA7000() )
    naf = ((f & 0x001f)<<16) + ((a & 0x000f)<<8) + (n & 0x001f);
  else
    naf = (((n-1) & 0x001f)<<9) + ((a & 0x000f)<<5) + (f & 0x0000001f);
  return( naf );
}

Tint TCamacModule::execute( Tint subaddress, Tint function )
{
  TUint naf = generateNAF( theSlotNumber, subaddress, function );
  if ( theDataLength == t16bitModule ) {
    return( execute16bit( naf ) );
  } else if ( theDataLength == t24bitModule ) {
    return( execute24bit( naf ) );
  } else {
    return( execute24bit( naf ) );
  }
}

Tint TCamacModule::execute16bit( TUint naf )
{
  struct CamacDriverInterface camacdata;
  camacdata._naf = naf;
  camacdata._q = 0;
  camacdata._x = 0;
  camacdata._data._d16 = (TUshort)theCamacData;

  errno ^= errno;
  ioctl( theCrateController -> GetFileDescriptor(), IOC_CAM16, &camacdata );
  theStatus = -errno;
  theCrateController -> SetStatus( theStatus );

  theQ = (Tint)camacdata._q;
  theX = (Tint)camacdata._x;
  theCamacData = (TUint)( camacdata._data._d16 );

  return( theStatus );
}

Tint TCamacModule::execute24bit( TUint naf )
{
  struct CamacDriverInterface camacdata;
  camacdata._naf = naf;
  camacdata._q = 0;
  camacdata._x = 0;
  camacdata._data._d24 = theCamacData;

  errno ^= errno;
  ioctl( theCrateController -> GetFileDescriptor(), IOC_CAM24, &camacdata );
  theStatus = -errno;
  theCrateController -> SetStatus( theStatus );

  theQ = (Tint)camacdata._q;
  theX = (Tint)camacdata._x;
  theCamacData = camacdata._data._d24;

  return( theStatus );
}
