// =====================================================================
//  $Id: isocket.cc,v 1.1.1.1 2003/06/27 02:56:41 goiwai Exp $
//  $Name: CLDAQ-1-06-00 $
// =====================================================================
#include "TDataRecord.hh"
#include "TInputObjectSocket.hh"
#include "TBenchmark.hh"

int main( int argc, char** argv, char** envv )
{
  enum { exCommand, exPort, exNumberOfArguments };
  if ( argc != exNumberOfArguments ) {
    Tcerr << "usage: " << argv[ exCommand ] << Tspace << "<port>" << Tendl;
    return( -1 );
  }
  const Tint port = atoi( argv[ exPort ] );
  TInputObjectSocket isocket( port );
  Tint nevents = 0;
  Tint datasize = 0;

  TDataRecord record;
  TBenchmark bench;
  bench.Start();
  while ( ( isocket >> record ) != 0 ) {
    Tcout << record << Tendl;
    datasize += record.GetRecordSize();
    nevents ++;
  }
  bench.Stop();
  Tcout << bench << Tendl;

  Tcout << nevents << " events, ";
  Tcout << datasize << Tslash << isocket.GetTotalDataSize();
  Tcout << " byte data has been received." << Tendl;

  return( 0 );
}
