#include "TDataRecord.hh"
#include "TDataSection.hh"
#include "TDataSegment.hh"
#include "TDataElement.hh"

inline TDataRecord testrecord( Tint val )
{
  TDataRecord record( "This is a Data Record." );
  TDataSection section( "This is Data Section." );
  TDataSegment segment0( "This is a Data Segement identified 0." );
  TDataSegment segment1( "This is a Data Segement identified 1." );
  TDataSegment segment2( "This is a Data Segement identified 2." );
  Ttime_t time_now;
  Tint pasttime = (Tint)time( &time_now );
  struct tm* tm_now = localtime( &time_now );
  Tsize_t length = 64;
  Tchar* tmp = new Tchar[ length ];
  strftime( tmp, length,"%Y/%m/%d %H:%M:%S", tm_now );
  Tstring tstr = tmp;
  delete [] tmp;
  const Tint nstrdata = 2;
  Tstring strdata[ nstrdata ] = { 
    "ABCDEF ABCDEF ABCDEF ABCDEF END", 
    "abcefghijklmnopqrstuvwxyz abcefghijklmnopqrstuvwxyz end"
  };
  const Tint ndata = 1000;
  TUshort array[ ndata ];
  for ( TUshort i = 0; i < ndata; i ++ ) {
    array[ i ] = i + i;
  }
  segment0.push_back( TDataElement( &pasttime, tTypeInt, "This is a integer data(TIME).", 1 ) );
  segment0.push_back( TDataElement( &tstr, tTypeString, "This is a string data(TIME).", 1 ) );
  segment0.push_back( TDataElement( strdata, tTypeString, "This is a string array.", nstrdata ) );
  segment0.push_back( TDataElement( array, tTypeUnsignedShort, "This is unsigned short data array.", ndata ) );
  for ( Tint i = 0; i < 8; i ++ ) {
    Tint data = i + i * i + 0x1234 * val;
    segment1.push_back( TDataElement( &data, tTypeInt, itostr( i ) ) );
  }
  for ( Tdouble i = 0.0; i < 16.0; i ++ ) {
    Tdouble data = sin( i ) / exp( i );
    segment2.push_back( TDataElement( &data, tTypeDouble, dtostr( i ) ) );
  }
  section.push_back( segment0 );
  section.push_back( segment1 );
  section.push_back( segment2 );
  record.push_back( section );
  return( record );
}
