// =====================================================================
//  $Id: rs01.cc,v 1.2 2003/07/07 22:42:30 goiwai Exp $
//  $Name: CLDAQ-1-06-02 $
// =====================================================================
#include "TRunManager.hh"
#include "Rs01RunAction.hh"
#include "Rs01EventAction.hh"
#include "Rs01CrateDefinition.hh"
#include "Rs01ReadoutBookDefinition.hh"
#include "Rs01ViewCommand.hh"
#include "Rs01VdcViewCommand.hh"

static const Tstring _rcpath = "rs01setup";

int main( int argc, char** argv, char** envv )
{
  TRunManager* manager = new TRunManager();
  manager -> GetEnvironmentVariableTable().SetEnvironment( _rcpath );
  manager -> SetRunAction( new Rs01RunAction() );
  manager -> SetEventAction( new Rs01EventAction() );
  manager -> SetCrateDefinition( new Rs01CrateDefinition() );
  manager -> SetReadoutBookDefinition( new Rs01ReadoutBookDefinition() );
  manager -> SetUserCommand( new Rs01ViewCommand() );
  manager -> SetUserCommand( new Rs01VdcViewCommand() );
  manager -> SessionStart();
  delete manager;
  return( 0 );
}
