// =====================================================================
//  $Id: St01Map.cc,v 1.2 2003/06/30 03:43:37 goiwai Exp $
//  $Name: CLDAQ-1-06-02 $
// =====================================================================
#include "St01Map.hh"

static const Tstring _rcfile = "st01setup";

St01Map::St01Map( const Tstring& filename )
  : theEnvironmentVariableTable( _rcfile ),
    theNumberOfHorizontalPixels( theEnvironmentVariableTable.GetIntegerValue( "ST01_HPIXEL" ) ),
    theNumberOfVerticalPixels( theEnvironmentVariableTable.GetIntegerValue( "ST01_VPIXEL" ) ),
    theHorizontalOffset( theEnvironmentVariableTable.GetIntegerValue( "ST01_HOFFSET" ) ),
    theVerticalOffset( theEnvironmentVariableTable.GetIntegerValue( "ST01_VOFFSET" ) ),
    theRateOfVerticalShift( theEnvironmentVariableTable.GetIntegerValue( "ST01_VSHIFT_CYCLE" ) ),
    theNumberOfHorizontalOverClockPixels( theEnvironmentVariableTable.GetIntegerValue( "ST01_HOC_PIXEL" ) ),
    theInputFileName( filename ),
    theHOCbuffer( 0.0 ),
    theMap( theNumberOfVerticalPixels, theNumberOfHorizontalPixels, 0 ),
    theHOCaverage( theNumberOfVerticalPixels, 0.0 )
{;}

St01Map::~St01Map()
{;}

Tpixel_t St01Map::IsThisPixel( Tint dataid ) const
{
  Tint colid = dataid % theRateOfVerticalShift;
  Tint rowid = dataid / theRateOfVerticalShift;
  Tint endofhoc = 276 + theNumberOfHorizontalOverClockPixels - 1;

  // ᤦǤϤʤե뤫褦
  // Ϥ4饤261饤ʹߤ̵
  if ( rowid >= 0 && rowid <= 3 ) {
    return( tIgnore );
  } else if ( rowid >= 260 ) {
    return( tIgnore );
  }

  if ( colid >= 0 && colid <= 3 ) {
    return( tBlank );
  } else if ( colid >= 4 && colid <= 11 ) {
    return( tOpticalBlack );
  } else if ( colid >= 12 && colid <= 267 ) {
    return( tSignal );
  } else if ( colid >= 268 && colid <= 271 ) {
    return( tOpticalBlack );
  } else if ( colid >= 272 && colid <= 275 ) {
    return( tBlank );
  } else if ( colid >= 276 && colid < endofhoc ) {
    return( tHoc );
  } else if ( colid == endofhoc ) {
    return( tEndOfHoc );
  } else if ( colid == 307 ) {
    return( tDummy );
  } else if ( colid >= 308 && colid <= 319 ) {
    return( tVerticalShift );
  } else {
    return( tIgnore );
  }
}

Tvoid St01Map::FillMap( Tshort* data, Tint ndata )
{
  theHOCaverage = TdoubleList( theNumberOfVerticalPixels, 0.0 );

  for ( Tint i = 0; i < ndata; i ++ ) {
    Tpixel_t pt = IsThisPixel( i );
    Tint colid = i % theRateOfVerticalShift - theHorizontalOffset;
    Tint rowid = i / theRateOfVerticalShift - theVerticalOffset;

    if ( pt == tSignal ) {
      theMap[ rowid ][ colid ] = (Tdouble)data[ i ];
    } else if ( pt == tHoc ) {
      theHOCbuffer += data[ i ];
    } else if ( pt == tEndOfHoc ) {
      theHOCbuffer += data[ i ];
      Tdouble ave = theHOCbuffer / (Tdouble)theNumberOfHorizontalOverClockPixels;
      theHOCaverage[ rowid ] = ave;
      for ( Tint col = 0; col < theNumberOfHorizontalPixels; col ++ ) {
	theMap[ rowid ][ col ] -= ave;
      }
      theHOCbuffer = 0.0;
    } else if ( rowid >= 256 ) {
      break;
    } else {
      continue;
    }
  }
  return;
}
