// =====================================================================
//  $Id: TModule.cc,v 1.1.1.1 2003/06/27 02:56:41 goiwai Exp $
//  $Name: CLDAQ-1-06-02 $
// =====================================================================
#include "TModule.hh"

TModule::TModule( Tint nchannel )
  : theNumberOfChannels( nchannel ),
    theStatus( tStatusSuccess )
{;}

TModule::TModule( const TModule& right )
  : theNumberOfChannels( right.theNumberOfChannels ),
    theStatus( right.theStatus )
{;}

TModule::~TModule()
{;}

const TModule& TModule::operator=( const TModule& right )
{
  theNumberOfChannels = right.theNumberOfChannels;
  theStatus = right.theStatus;
  return( *this );
}

Tbool TModule::operator==( const TModule& right ) const
{
  return( theNumberOfChannels == right.theNumberOfChannels && theStatus == right.theStatus );
}

Tbool TModule::operator!=( const TModule& right ) const
{
  return( theNumberOfChannels != right.theNumberOfChannels || theStatus != right.theStatus );
}
