// =====================================================================
//  $Id: TModuleTable.cc,v 1.1.1.1 2003/06/27 02:56:41 goiwai Exp $
//  $Name: CLDAQ-1-06-02 $
// =====================================================================
#include "TModuleTable.hh"

TModuleTable::TModuleTable()
  : Tvector<TModuleSpecified>()
{;}

TModuleTable::~TModuleTable()
{;}

TModule* TModuleTable::FindModule( const Tstring& id ) const
{
  for ( Tsize_t i = 0; i < size(); i ++ ) {
    if ( (*this)[ i ].GetModuleID() == id ) {
      return( (*this)[ i ].GetModule() );
    }
  }
  return( 0 );
}

Tvoid TModuleTable::AddModule( TModule* module, const Tstring& id, const TstringList& groups )
{
  TModuleSpecified spec( id, groups, module );
  push_back( spec );
  return;
}

Tvoid TModuleTable::RemoveModule( Tint index )
{
  erase( begin() + index );
  return;
}

Tint TModuleTable::GetSize() const
{
  return( (Tint)size() );
}

Tvoid TModuleTable::Clear()
{
  clear();
  return;
}
