// =====================================================================
//  $Id: TInputObjectFile.hh,v 1.1.1.1 2003/06/27 02:56:41 goiwai Exp $
//  $Name: CLDAQ-1-06-02 $
// =====================================================================
#ifndef __TINPUTOBJECTFILE_HH
#define __TINPUTOBJECTFILE_HH

#include "Tglobals.h"
#include "TObjectFile.hh"
#include "TInputObjectStream.hh"

class TStreamableObject;
class TDataRecord;
class TDataSection;
class TDataSegment;
class TDataElement;
class TObjectFilter;

class TInputObjectFile
  : public TObjectFile, public TInputObjectStream
{

  public:
    TInputObjectFile( const Tstring& filename, const Tstring& mode = "r" );
    TInputObjectFile( TObjectFilter* filter, const Tstring& filename, const Tstring& mode = "r" );
    ~TInputObjectFile();

  public:
    Tint Read( TStreamableObject& object );
  
  private:
    TDataRecord getDataRecord();
    TDataSection getDataSection();
    TDataSegment getDataSegment();
    TDataElement getDataElement();
    Tvoid readProperties( Tint& recsize, Tobject_t& type, Tstring& id, Tsize_t& entries );

};

#endif
