// =====================================================================
//  $Id: compress.cc,v 1.1.1.1 2003/06/27 02:56:41 goiwai Exp $
//  $Name: CLDAQ-1-06-02 $
// =====================================================================
#include "TDataDeflation.hh"

int main( int argc, char** argv, char** envv )
{
#ifdef __CLDAQ_ZLIB_USE
  if ( argc != 3 ) {
    Tcerr << "usage: " << argv[ 0 ] << " <input> <output>" << Tendl;
    return( -1 );
  }
  const Tstring ifname = argv[ 1 ];
  const Tstring ofname = argv[ 2 ];

  TDataDeflation deflation;

  const Tint bufsize = 256;
  Tbyte input[ bufsize ]; 

  Tifstream ifs;
  ifs.open( ifname.c_str() );

  Tofstream ofs;
  ofs.open( ofname.c_str() );

  while ( ifs.good() && !ifs.eof() ) {
    ifs.read( (Tchar*)input, bufsize );
    if ( ifs.gcount() < bufsize ) {
      deflation.Compress( input, ifs.gcount(), Ttrue );
    } else {
      deflation.Compress( input, ifs.gcount() );
    }
    ofs.write( (Tchar*)deflation.GetDeflatedData(), deflation.GetSizeOfDeflatedData() );
  }

  ifs.close();
  ofs.close();
#endif
  return( 0 );
}
