// =====================================================================
//  $Id: Bt00ReadoutBookDefinition.cc,v 1.2 2003/07/30 16:13:49 goiwai Exp $
//  $Name: CLDAQ-1-07-00 $
//
//  $Log: Bt00ReadoutBookDefinition.cc,v $
//  Revision 1.2  2003/07/30 16:13:49  goiwai
//  ե˥ߥåȥĤ뤳Ȥˤޤ.
//
// =====================================================================
#include "TReadoutList.hh"
#include "TReadoutSection.hh"
#include "TReadoutSegment.hh"
#include "TCrate.hh"
#include "TReadoutBook.hh"

#include "Bt00ReadoutBookDefinition.hh"

Bt00ReadoutBookDefinition::Bt00ReadoutBookDefinition()
  : TReadoutBookDefinition()
{;}

Bt00ReadoutBookDefinition::~Bt00ReadoutBookDefinition()
{;}

TReadoutBook* Bt00ReadoutBookDefinition::Define()
{
  TReadoutBook* book = new TReadoutBook();

  // define run begin record
  TReadoutList* runbegin = new TReadoutList( "RUN BEGIN" );
  TReadoutSection sec0( "INFO" );
  TReadoutSegment runid( theCrate -> GetModule( "Run ID" ), "RUN ID" );
  TReadoutSegment runinfo( theCrate -> GetModule( "Run Information" ), "RUN INFORMATION" );
  TReadoutSegment clock( theCrate -> GetModule( "Clock" ), "CLOCK" );
  TReadoutSegment scaler( theCrate -> GetModule( "Scaler" ), "SCALER" );
  sec0.push_back( runid );
  sec0.push_back( runinfo );
  sec0.push_back( clock );
  sec0.push_back( scaler );
  runbegin -> push_back( sec0 );


  // define run end record
  TReadoutList* runend = new TReadoutList( "RUN END" );
  TReadoutSection sec1( "INFO" );
  sec1.push_back( runinfo );
  sec1.push_back( clock );
  sec1.push_back( scaler );
  runend -> push_back( sec1 );


  // define CsI event record
  TReadoutList* csievent = new TReadoutList( "CSI EVENT" );
  TReadoutSection sec2( "EVENT" );
  TReadoutSegment eventid( theCrate -> GetModule( "Event ID" ), "EVENT ID" );
  TReadoutSegment adc( theCrate -> GetModule( "ADC" ), "ADC" );
  TReadoutSegment cr( theCrate -> GetModule( "Coincidence Register" ), "COINCIDENCE" );
  TReadoutSegment timer( theCrate -> GetModule( "Timer" ), "TIMER" );
  sec2.push_back( eventid );
  sec2.push_back( adc );
  sec2.push_back( cr );
  sec2.push_back( timer );
  csievent -> push_back( sec2 );


  // define Scaler event record
  TReadoutList* scalerevent = new TReadoutList( "SCALER EVENT" );
  TReadoutSection sec3( "EVENT" );
  sec3.push_back( eventid );
  sec3.push_back( scaler );
  scalerevent -> push_back( sec3 );


  book -> AddReadoutList( runbegin );
  book -> AddReadoutList( runend );
  book -> AddReadoutList( csievent );
  book -> AddReadoutList( scalerevent );


  return( book );
}
