// =====================================================================
//  $Id: Sw00ReadoutBookDefinition.cc,v 1.2 2003/07/30 16:15:15 goiwai Exp $
//  $Name: CLDAQ-1-07-00 $
//
//  $Log: Sw00ReadoutBookDefinition.cc,v $
//  Revision 1.2  2003/07/30 16:15:15  goiwai
//  ե˥ߥåȥĤ뤳Ȥˤޤ.
//
// =====================================================================
#include "TReadoutList.hh"
#include "TReadoutSection.hh"
#include "TReadoutSegment.hh"
#include "TCrate.hh"
#include "TReadoutBook.hh"

#include "Sw00ReadoutBookDefinition.hh"

Sw00ReadoutBookDefinition::Sw00ReadoutBookDefinition()
  : TReadoutBookDefinition()
{;}

Sw00ReadoutBookDefinition::~Sw00ReadoutBookDefinition()
{;}

TReadoutBook* Sw00ReadoutBookDefinition::Define()
{
  TReadoutBook* book = new TReadoutBook();

  TReadoutList* runbegin = new TReadoutList( "RUN BEGIN" );
  TReadoutSection sec0( "Run Information" );
  TReadoutSegment seg0( theCrate -> GetModule( "Run ID" ), "Run ID" );
  TReadoutSegment seg1( theCrate -> GetModule( "Clock" ), "Clock" );
  TReadoutSegment seg2( theCrate -> GetModule( "Run Information" ), "Run Information" );
  sec0.push_back( seg0 );
  sec0.push_back( seg1 );
  sec0.push_back( seg2 );
  runbegin -> push_back( sec0 );


  TReadoutList* event = new TReadoutList( "EVENT" );
  TReadoutSection sec1( "Event Data" );
  TReadoutSegment seg3( theCrate -> GetModule( "Event ID" ), "Event ID" );
  TReadoutSegment seg4( theCrate -> GetModule( "ADC" ), "ADC" );
  TReadoutSegment seg5( theCrate -> GetModule( "Flash ADC" ), "Flash ADC" );
  TReadoutSegment seg6( theCrate -> GetModule( "Geant4" ), "Geant4" );
  TReadoutSegment seg7( theCrate -> GetModule( "Interrupt Register" ), "Interrupt Register" );
  TReadoutSegment seg8( theCrate -> GetModule( "Timer" ), "Timer" );
  sec1.push_back( seg3 );
  sec1.push_back( seg4 );
  sec1.push_back( seg5 );
  sec1.push_back( seg6 );
  sec1.push_back( seg7 );
  event -> push_back( sec1 );


  TReadoutList* runend = new TReadoutList( "RUN END" );
  runend -> push_back( sec0 );


  book -> AddReadoutList( runbegin );
  book -> AddReadoutList( runend );
  book -> AddReadoutList( event );


  return( book );
}
