// =====================================================================
//  $Id: st00minushocview.cc,v 1.2 2003/07/30 16:15:52 goiwai Exp $
//  $Name: CLDAQ-1-07-00 $
//
//  $Log: st00minushocview.cc,v $
//  Revision 1.2  2003/07/30 16:15:52  goiwai
//  ե˥ߥåȥĤ뤳Ȥˤޤ.
//
// =====================================================================
#include <TROOT.h>
#include <TSystem.h>
#include <TApplication.h> 
#include <TStyle.h>
#include <TGraph.h>
#include <TH1.h>
#include <TH2.h>
#include <TCanvas.h>
#include <TNtuple.h>
#include <TFile.h>
#include <TPad.h>

#include "TDataRecord.hh"
#include "TDataSection.hh"
#include "TDataSegment.hh"
#include "TDataElement.hh"
#include "TInputObjectFile.hh"
#include "St00DataRecordConversion.hh"

int main( int argc, char** argv, char** envv )
{
  if ( argc != 6 ) {
    Tcerr << "usage: " << argv[ 0 ] << " <filename> <title> <nbin> <xmin> <xmax>" << Tendl;
    return( -1 );
  }
  Tstring filename = argv[ 1 ];
  TInputObjectFile ifile( filename );
  Tstring htitle = argv[ 2 ];
  Tint nbin = strtol( argv[ 3 ], 0, 0 );
  Tdouble xmin = strtod( argv[ 4 ], 0 );
  Tdouble xmax = strtod( argv[ 5 ], 0 );


  TApplication* theApplication = new TApplication( "root-analyser", 0, 0 );
  gROOT -> Reset( 0 );
  gROOT -> Reset( 0 );
  gStyle -> SetStatColor(42);
  gStyle -> SetTitleColor(42);
  gStyle -> SetFrameFillColor( 21 );
  gStyle -> SetFrameFillStyle( 1 );
  gStyle -> SetMarkerStyle( 7 );
  gStyle -> SetFuncColor( 4 );
  gStyle -> SetOptStat( 1111110 );
  gStyle -> SetOptFit( 1111 );
  gStyle -> SetPadGridX( kTRUE );
  gStyle -> SetPadGridY( kTRUE );

  TCanvas cv( "CVfadc", "Pentland MPX201A" );
  TH1D mpx201a( "mpx201a", htitle.c_str(), nbin, xmin, xmax );
  mpx201a.SetFillColor( 45 );

  TDataRecord record;
  St00DataRecordConversion conversion;

  while ( 1 ) {
    Tint datasize = ifile >> record;
    if ( datasize == 0 ) {
      ifile.SetOffset( ifile.GetTotalDataSize(), SEEK_SET );
      gSystem -> ProcessEvents();
      sleep( 1 );
      continue;
    }

    TDataElement element;
    Tstring recid = record.GetID();

    if ( recid == "RUN BEGIN" ) {
      continue;
    } else if ( recid == "EVENT" ) {
      TDataMultiplicity& map = conversion.Convert( record );
      for ( Tint row = 0; row < map.num_row(); row ++ ) {
	for ( Tint col = 0; col < map.num_col(); col ++ ) {
	  mpx201a.Fill( map[ row ][ col ] );
	}
      }
      cv.cd();
      mpx201a.Draw();
      cv.Modified();
      cv.Update();
    } else if ( recid == "RUN END" ) {
      break;
    } else {
      Tcerr << "unknown tag: " << recid << Tendl;
    }
    gSystem -> ProcessEvents();
  }

  theApplication -> Run();

  return( 0 );
}
