// =====================================================================
//  $Id: St02DarkDataSet.cc,v 1.2 2003/07/30 16:16:34 goiwai Exp $
//  $Name: CLDAQ-1-07-00 $
//
//  $Log: St02DarkDataSet.cc,v $
//  Revision 1.2  2003/07/30 16:16:34  goiwai
//  ե˥ߥåȥĤ뤳Ȥˤޤ.
//
// =====================================================================
#include "St02DarkDataSet.hh"

St02DarkDataSet::St02DarkDataSet( Tdouble temp, Tdouble cycle, Tdouble v, Tdouble ave, Tdouble rms, Tdouble ndata, Tint nbad, const Tstring& file )
  : theTemperature( temp ),
    theCycle( cycle ),
    theVoltage( v ),
    theAverage( ave ),
    theRms( rms ),
    theNumberOfData( ndata ),
    theNumberOfBadChannels( nbad ),
    theFileName( file )
{;}

St02DarkDataSet::St02DarkDataSet( const St02DarkDataSet& right )
  : theTemperature( right.theTemperature ),
    theCycle( right.theCycle ),
    theVoltage( right.theVoltage ),
    theAverage( right.theAverage ),
    theRms( right.theRms ),
    theNumberOfData( right.theNumberOfData ),
    theNumberOfBadChannels( right.theNumberOfBadChannels ),
    theFileName( right.theFileName )
{;}

St02DarkDataSet::~St02DarkDataSet()
{;}

const St02DarkDataSet& St02DarkDataSet::operator=( const St02DarkDataSet& right )
{
  theTemperature = right.theTemperature;
  theCycle = right.theCycle;
  theVoltage = right.theVoltage;
  theAverage = right.theAverage;
  theRms = right.theRms;
  theNumberOfData = right.theNumberOfData;
  theNumberOfBadChannels = right.theNumberOfBadChannels;
  theFileName = right.theFileName;
  return( *this );
}

Tostream& operator<<( Tostream& tos, const St02DarkDataSet& right )
{
  tos << right.theTemperature << Tspace;
  tos << right.theCycle << Tspace;
  tos << right.theVoltage << Tspace;
  tos << right.theAverage << Tspace;
  tos << right.theRms << Tspace;
  tos << right.theNumberOfData << Tspace;
  tos << right.theNumberOfBadChannels << Tspace;
  tos << right.theFileName << Tflush;
  return( tos );
}

Tistream& operator>>( Tistream& tis, St02DarkDataSet& right )
{
  tis >> right.theTemperature >> right.theCycle >> right.theVoltage;
  tis >> right.theAverage >> right.theRms >> right.theNumberOfData;
  tis >> right.theNumberOfBadChannels >> right.theFileName;
  return( tis );
}
