// =====================================================================
//  $Id: TCommand.hh,v 1.2 2003/07/30 16:17:31 goiwai Exp $
//  $Name: CLDAQ-1-07-00 $
//
//  $Log: TCommand.hh,v $
//  Revision 1.2  2003/07/30 16:17:31  goiwai
//  ե˥ߥåȥĤ뤳Ȥˤޤ.
//
// =====================================================================
#ifndef __TCOMMAND_HH
#define __TCOMMAND_HH

#include "Tglobals.h"

class TRunManager;

class TCommand
{

  protected:
    TRunManager* theRunManager;
    Tstring theCommandName;
    Tstring theGuidance;

  public:
    TCommand( TRunManager* manager, const Tstring& name, const Tstring& guidance = "" );
    TCommand( const Tstring& name, const Tstring& guidance = "" );
    virtual ~TCommand();

  public:
    TRunManager* GetRunManager() const;
    Tvoid SetRunManager( TRunManager* manager );
    const Tstring& GetCommandName() const;
    const Tstring& GetGuidance() const;
    Tvoid SetCommandName( const Tstring& name );
    Tvoid SetGuidance( const Tstring& guidance );

  public:
    virtual Tvoid Execute( const TstringList& arguments );
    virtual Tvoid ShowCommandDetail() const;

};

inline const Tstring& TCommand::GetCommandName() const
{
  return( theCommandName );
}

inline const Tstring& TCommand::GetGuidance() const
{
  return( theGuidance );
}

inline Tvoid TCommand::SetCommandName( const Tstring& name )
{
  theCommandName = name;
  return;
}

inline Tvoid TCommand::SetGuidance( const Tstring& guidance )
{
  theGuidance = guidance;
  return;
}

inline TRunManager* TCommand::GetRunManager() const
{
  return( theRunManager );
}

inline Tvoid TCommand::SetRunManager( TRunManager* manager )
{
  theRunManager = manager;
  return;
}

#endif
