// =====================================================================
//  $Id: TEvent.hh,v 1.2 2003/07/30 16:18:09 goiwai Exp $
//  $Name: CLDAQ-1-07-00 $
//
//  $Log: TEvent.hh,v $
//  Revision 1.2  2003/07/30 16:18:09  goiwai
//  ե˥ߥåȥĤ뤳Ȥˤޤ.
//
// =====================================================================
#ifndef __TEVENT_HH
#define __TEVENT_HH

#include "Tglobals.h"
#include "TDataRecord.hh"

class TDataRecord;

class TEvent
{
    
  private:
    Tint theEventID;
    TDataRecord theDataRecord;

  public:
    TEvent( Tint eventID = 0 );
    TEvent( const TDataRecord& eventData );
    TEvent( Tint eventID, const TDataRecord& eventData );
    TEvent( const TEvent& right );
    ~TEvent();

  public:
    const TEvent& operator=( const TEvent& right );
    Tbool operator==( const TEvent& right ) const;
    Tbool operator!=( const TEvent& right ) const;

  public:
    Tint GetEventID() const;
    const TDataRecord& GetDataRecord() const;
    TDataRecord& GetDataRecord();
    Tvoid SetEventID( Tint eventID );
    Tvoid SetDataRecord( const TDataRecord& record );

  public:
    Tvoid Clear();
    Tstring GetStringEventID( Tint digits = 6 ) const;

};

inline Tint TEvent::GetEventID() const
{
  return( theEventID );
}

inline const TDataRecord& TEvent::GetDataRecord() const
{
  return( theDataRecord );
}

inline TDataRecord& TEvent::GetDataRecord()
{
  return( theDataRecord );
}

inline Tvoid TEvent::SetEventID( Tint eventID )
{
  theEventID = eventID;
  return;
}

inline Tvoid TEvent::SetDataRecord( const TDataRecord& record )
{
  theDataRecord = record;
  return;
}

#endif
