// =====================================================================
//  $Id: TInputObjectSocket.hh,v 1.2 2003/07/30 16:19:30 goiwai Exp $
//  $Name: CLDAQ-1-07-00 $
//
//  $Log: TInputObjectSocket.hh,v $
//  Revision 1.2  2003/07/30 16:19:30  goiwai
//  ե˥ߥåȥĤ뤳Ȥˤޤ.
//
// =====================================================================
#ifndef __TINPUTOBJECTSOCKET_HH
#define __TINPUTOBJECTSOCKET_HH

#include "Tglobals.h"
#include "TObjectSocket.hh"
#include "TInputObjectStream.hh"

class TStreamableObject;
class TObjectFilter;
class TDataRecord;
class TDataSection;
class TDataSegment;
class TDataElement;

class TInputObjectSocket
  : public TObjectSocket, public TInputObjectStream
{

  private:
    enum { tDefaultBackLog = 5 };

  private:
    Tint theClientDescriptor;

  public:
    TInputObjectSocket( Tint port = tDefaultPortNumber );
    TInputObjectSocket( TObjectFilter* filter, Tint port = tDefaultPortNumber );
    ~TInputObjectSocket();

  public:
    Tint Read( TStreamableObject& object );

  private:
    TDataRecord getDataRecord();
    TDataSection getDataSection();
    TDataSegment getDataSegment();
    TDataElement getDataElement();
    Tvoid readProperties( Tint& recsize, Tobject_t& type, Tstring& id, Tsize_t& entries );
    Tvoid initialize();

  public:
    Tint GetClientDescriptor() const;
    // GetClientHostName()
    // GetClientPort()
    Tint OpenClient();
    Tint CloseClient();

};


inline Tint TInputObjectSocket::GetClientDescriptor() const
{
  return( theClientDescriptor );
}

#endif
