// =====================================================================
//  $Id: rs01OFFview.cc,v 1.1 2003/08/17 20:15:37 goiwai Exp $
//  $Name: CLDAQ-1-08-00 $
//
//  $Log: rs01OFFview.cc,v $
//  Revision 1.1  2003/08/17 20:15:37  goiwai
//  OFFxxx.cc Ȥ̾ΤĤե̾ rs01OFFxxx.cc ѹޤ.
//
//  Revision 1.2  2003/07/30 16:14:40  goiwai
//  ե˥ߥåȥĤ뤳Ȥˤޤ.
//
// =====================================================================
#include "TDataRecord.hh"
#include "TDataSection.hh"
#include "TDataSegment.hh"
#include "TDataElement.hh"
#include "TEnvironmentVariableTable.hh"
#include "TInputObjectFile.hh"
#include "Trootinit.h"

static const Tstring rcpath = "rs01setup";
static const Tint npin = 32;
// static Tint pinpos[ npin ] = {
//            3,  4, 5,   6,  7,
//       10, 11, 12, 13, 14, 15, 16,
//   17, 18, 19, 20, 21, 22, 23, 24,
//       26, 27, 28, 29, 30, 31, 32,
//           35, 36, 37, 38, 39
// };

TInputObjectFile* ifile = 0;
TEnvironmentVariableTable* envtable = 0;
TDataRecord record;
TDataElement element;
Tdouble vdc[ npin ];
Tint elapsed[ npin ];
Tdouble integrated[ npin ];
Tdouble pedestal[ npin ];

TApplication* theApplication = 0;
TCanvas* CVpro = 0;
static const Tint nx = 3;
static const Tint ny = 3;
static const Tint npadvdc = nx * ny;
TH1D* H1Dvdc[ npin ];
Tstring htvdc[ npin ];
Tstring hnamevdc[ npin ];

Tstring fpath, macrof, giff, psf, rootf;
static Tbool autoprint, enableoverwrite;
static Tint modperiod;

static Tvoid initialize( Tint argc, Tchar** argv );
static Tvoid event();
static Tvoid runbegin();
static Tvoid runend();
static Tvoid sizezero();

int main( int argc, char** argv, char** envv )
{
  initialize( argc, argv );

  while ( 1 ) {
    Tint datasize = ifile -> Read( record );
    if ( datasize == 0 ) {
      sizezero();
      continue;
    }

    Tstring recid = record.GetID();
    if ( recid == "RUN BEGIN" ) {
      runbegin();
      continue;
    } else if ( recid == "EVENT" ) {
      event();
    } else if ( recid == "RUN END" ) {
      runend();
      break;
    } else {
      Tcerr << "unknown tag: " << recid << Tendl;
      break;
    }
    gSystem -> ProcessEvents();
  }

  theApplication -> Run();
  return( 0 );
}

Tvoid initialize( Tint argc, Tchar** argv )
{
  if ( argc != 2 ) {
    Tcerr << "usage: " << argv[ 0 ] << " <run#>" << Tendl;
    exit( -1 );
  }

  Tint runid = (Tint)strtol( argv[ 1 ], 0, 0 );
  Tstring runidstr = itostr( runid );

  Tstring htpro = "Beam Profile Monitor, Run ID: " + runidstr;
  Tstring htint = "Beam Profile Monitor(Integrated), Run ID: " + runidstr;

  envtable = new TEnvironmentVariableTable ( rcpath );
  Tstring rechead = envtable -> GetEnvironmentValue( "RS01_RECORD_HEAD" );
  Tstring recpath = envtable -> GetEnvironmentValue( "RS01_RECORD_DIR" );
  fpath = recpath + Tslash + rechead + runidstr + ".drec";
  ifile = new TInputObjectFile( fpath );


  Tstring rootdir = envtable -> GetEnvironmentValue( "RS01_ROOTFILE_DIR" );
  rootf = rootdir + Tslash + rechead + runidstr + "OFFview.root";
  Tstring macrodir = envtable -> GetEnvironmentValue( "RS01_ROOTFILE_DIR" );
  macrof = macrodir + Tslash + rechead + runidstr + "OFFview.C";
  Tstring gifdir = envtable -> GetEnvironmentValue( "RS01_FIGURE_DIR" );
  giff = gifdir + Tslash + rechead + runidstr + "OFFview.gif";
  Tstring psdir = envtable -> GetEnvironmentValue( "RS01_FIGURE_DIR" );
  psf = psdir + Tslash + rechead + runidstr + "OFFview.ps";

  modperiod = envtable -> GetIntegerValue( "RS01_UPDATE_PERIOD" );
  enableoverwrite = (Tbool)envtable -> GetIntegerValue( "RS01_OVERWRITE_ENABLE" );
  autoprint = (Tbool)envtable -> GetIntegerValue( "RS01_AUTO_PRINT" );

  // ڥǥ
  for ( Tint i = 0; i < npin; i ++ ) {
    Tstring item = "RS01_PEDESTAL_" + itostr( i, 2 );
    pedestal[ i ] = envtable -> GetDoubleValue( item );
  }



  theApplication = rootinit();
  TGaxis::SetMaxDigits( 1 );

  // ҥåȤ2D Х
  CVpro = new TCanvas( "CVpro", "Distribution", 960, 720 );
  CVpro -> ToggleEventStatus();
  CVpro -> Divide( 3, 3 );


  for ( Tint ch = 0; ch < npin; ch ++ ) {
    htvdc[ ch ] = "Channel: " + itostr( ch, 2 ) + ", Run ID: " + runidstr;
    hnamevdc[ ch ] = "H1Dvdc" + itostr( ch, 2 );

    H1Dvdc[ ch ] = 
      new TH1D( hnamevdc[ ch ].c_str(), htvdc[ ch ].c_str(), 10, 0.0, 10.0 );


    H1Dvdc[ ch ] -> SetStats( 0 );
    H1Dvdc[ ch ] -> GetXaxis() -> SetTimeDisplay( 1 );
    H1Dvdc[ ch ] -> SetMarkerStyle( 1 );
    H1Dvdc[ ch ] -> SetLineColor( 10 );
    H1Dvdc[ ch ] -> SetLineStyle( 0 );
    H1Dvdc[ ch ] -> SetLineWidth( 0 );

    H1Dvdc[ ch ] -> GetXaxis() -> SetNdivisions( 504 );
    H1Dvdc[ ch ] -> GetXaxis() -> SetTimeFormat( "%H:%M:%S" );
    H1Dvdc[ ch ] -> GetXaxis() -> SetTitle( "Time (H:M:S)" );
    H1Dvdc[ ch ] -> GetXaxis() -> CenterTitle();
    H1Dvdc[ ch ] -> GetYaxis() -> SetTitle( "Integrated Voltage (Vsec)" );
    H1Dvdc[ ch ] -> GetYaxis() -> CenterTitle();
    H1Dvdc[ ch ] -> GetYaxis() -> SetNoExponent();
  }

  //ɽΤ 7,8,9 15,16,17 22,23,24
  CVpro -> cd( 1 );
  H1Dvdc[ 7 ] -> Draw( "pe" );

  CVpro -> cd( 2 );
  H1Dvdc[ 8 ] -> Draw( "pe" );

  CVpro -> cd( 3 );
  H1Dvdc[ 9 ] -> Draw( "pe" );

  CVpro -> cd( 4 );
  H1Dvdc[ 15 ] -> Draw( "pe" );

  CVpro -> cd( 5 );
  H1Dvdc[ 16 ] -> Draw( "pe" );

  CVpro -> cd( 6 );
  H1Dvdc[ 17 ] -> Draw( "pe" );

  CVpro -> cd( 7 );
  H1Dvdc[ 22 ] -> Draw( "pe" );

  CVpro -> cd( 8 );
  H1Dvdc[ 23 ] -> Draw( "pe" );

  CVpro -> cd( 9 );
  H1Dvdc[ 24 ] -> Draw( "pe" );

  return;
}

Tvoid event()
{
  for ( Tint ch = 0; ch < npin; ch ++ ) {
    // VDCΥʥåץå
    element = record[ 1 ][ ch ][ 0 ];
    element.StorePrimitives( &vdc[ ch ] );

    // ɤߤηвÿ(msec)
    element = record[ 1 ][ ch ][ 4 ];
    Tdouble secbuf;
    element.StorePrimitives( &secbuf );
    secbuf /= 1000.0;

    // ڥǥΤȤ
    integrated[ ch ] += ( vdc[ ch ] - pedestal[ ch ] ) * secbuf;

    // 󳫻Ϥηвÿ(sec)
    element = record[ 1 ][ ch ][ 3 ];
    element.StorePrimitives( &elapsed[ ch ] );

    // ʬŰ VS 
    H1Dvdc[ ch ] -> SetBinContent( elapsed[ ch ], integrated[ ch ] );

    H1Dvdc[ ch ] -> GetXaxis() -> SetNdivisions( 504 );
    H1Dvdc[ ch ] -> GetXaxis() -> SetTimeFormat( "%H:%M:%S" );
    H1Dvdc[ ch ] -> GetXaxis() -> SetTitle( "Time (H:M:S)" );
    H1Dvdc[ ch ] -> GetXaxis() -> CenterTitle();
    H1Dvdc[ ch ] -> GetYaxis() -> SetTitle( "Integrated Voltage (Vsec)" );
    H1Dvdc[ ch ] -> GetYaxis() -> CenterTitle();
    H1Dvdc[ ch ] -> GetYaxis() -> SetNoExponent();

    H1Dvdc[ ch ] -> SetDrawOption( "pe" );
  }


  // update
  element = record[ 0 ][ 0 ][ 0 ];
  Tint eventid;
  element.StorePrimitives( &eventid );
  if ( eventid % modperiod == 0 ) {
    for ( Tint i = 0; i < npadvdc; i ++ ) {
      CVpro -> GetPad(i+1)->Modified();
      CVpro -> GetPad(i+1)->Update();
    }
  }

  return;
}

Tvoid runbegin()
{
  element = record[ 0 ][ 1 ][ 1 ];
  Tint secbuf;
  element.StorePrimitives( &secbuf );
  gStyle -> SetTimeOffset( secbuf );
  return;
}

Tvoid runend()
{
  TLatex* tex[ npin ];
  for ( Tint ch = 0; ch < npin; ch ++ ) {
    Tdouble max = H1Dvdc[ ch ] -> GetMaximum();
    Tstring sbuf = "Max: " + dtostr( max ) + " (Vsec)";
    tex[ ch ] = new TLatex( 2500.0, 50.0, sbuf.c_str() );
  }
  //ɽΤ 7,8,9 15,16,17 22,23,24
  CVpro -> cd( 1 );
  tex[ 7 ] -> Draw();
  CVpro -> cd( 2 );
  tex[ 8 ] -> Draw();
  CVpro -> cd( 3 );
  tex[ 9 ] -> Draw();
  CVpro -> cd( 4 );
  tex[ 15 ] -> Draw();
  CVpro -> cd( 5 );
  tex[ 16 ] -> Draw();
  CVpro -> cd( 6 );
  tex[ 17 ] -> Draw();
  CVpro -> cd( 7 );
  tex[ 22 ] -> Draw();
  CVpro -> cd( 8 );
  tex[ 23 ] -> Draw();
  CVpro -> cd( 9 );
  tex[ 24 ] -> Draw();






  // update
  for ( Tint i = 0; i < npadvdc; i ++ ) {
    CVpro -> GetPad(i+1)->Modified();
    CVpro -> GetPad(i+1)->Update();
  }



  // printout
  CVpro -> cd();
  if ( !isexist( rootf ) || enableoverwrite ) {
    CVpro -> Print( rootf.c_str() );
  }
  if ( !isexist( macrof ) || enableoverwrite ) {
    CVpro -> Print( macrof.c_str() );
  }
  if ( !isexist( giff ) || enableoverwrite ) {
    CVpro -> Print( giff.c_str() );
  }
  if ( !isexist( psf ) || enableoverwrite ) {
    CVpro -> Print( psf.c_str() );
    if ( autoprint ) {
      Tstring exec = "lpr " + psf;
      system( exec.c_str() );
    }
  }

  return;
}

Tvoid sizezero()
{
  ifile -> SetOffset( ifile -> GetTotalDataSize(), SEEK_SET );
  usleep( 1000*1000 );
  gSystem -> ProcessEvents();
  return;
}
