// =====================================================================
//  $Id: St02RunAction.hh,v 1.2 2003/07/30 16:16:34 goiwai Exp $
//  $Name: CLDAQ-1-08-00 $
//
//  $Log: St02RunAction.hh,v $
//  Revision 1.2  2003/07/30 16:16:34  goiwai
//  ե˥ߥåȥĤ뤳Ȥˤޤ.
//
// =====================================================================
#ifndef __ST02RUNACTION_HH
#define __ST02RUNACTION_HH

#include "TRunAction.hh"
#include "TOutputHtmlFileStream.hh"

class TRun;
class TOutputObjectFile;
class TInputObjectFile;
class TDataRecord;
class St02RunSummary;

class St02RunAction
  : public TRunAction
{

  private:
    TOutputObjectFile* theOutputFile;
    St02RunSummary* theRunSummary;
    TOutputHtmlFileStream theOutputHtml;

  public:
    St02RunAction();
    ~St02RunAction();

  public:
    Tvoid BeginOfRunAction( TRun& aRun );
    Tvoid EndOfRunAction( TRun& aRun );
    Tvoid FinalOfRunAction( TRun& aRun );

  public:
    TOutputObjectFile* GetOutputFile() const;
    St02RunSummary* GetRunSummary() const;
    TOutputHtmlFileStream& GetOutputHtml();

  private:
    Tvoid fillRunBeginInformation( const TDataRecord& record );
    Tvoid fillRunEndInformation( const TDataRecord& record );
    Tvoid setFileName( Tint runid, Tstring& drecfile, Tstring& htmlfile );

};

inline TOutputObjectFile* St02RunAction::GetOutputFile() const
{
  return( theOutputFile );
}

inline St02RunSummary* St02RunAction::GetRunSummary() const
{
  return( theRunSummary );
}

inline TOutputHtmlFileStream& St02RunAction::GetOutputHtml()
{
  return( theOutputHtml );
}

#endif
