// =====================================================================
//  $Id: St02RunInformationExtractor.hh,v 1.2 2003/07/30 16:16:34 goiwai Exp $
//  $Name: CLDAQ-1-08-00 $
//
//  $Log: St02RunInformationExtractor.hh,v $
//  Revision 1.2  2003/07/30 16:16:34  goiwai
//  ե˥ߥåȥĤ뤳Ȥˤޤ.
//
// =====================================================================
#ifndef __ST02RUNINFORMATIONEXTRACTOR_HH
#define __ST02RUNINFORMATIONEXTRACTOR_HH

#include "Tglobals.h"

class St02RunInformationExtractor
{

  private:
    Tstring theRecordPath;
    TstringList theElementTags;
    TstringList theElements;

  public:
    St02RunInformationExtractor( const Tstring& recpath );
    ~St02RunInformationExtractor();

  public:
    friend Tostream& operator<<( Tostream& tos, const St02RunInformationExtractor& right );

  public:
    const Tstring& GetRecordPath() const;
    const TstringList& GetElementTags() const;
    const TstringList& GetElements() const;
    const Tstring& GetElementTag( Tint index ) const;
    const Tstring& GetElement( Tint index ) const;

};

inline const Tstring& St02RunInformationExtractor::GetRecordPath() const
{
  return( theRecordPath );
}

inline const TstringList& St02RunInformationExtractor::GetElementTags() const
{
  return( theElementTags );
}

inline const TstringList& St02RunInformationExtractor::GetElements() const
{
  return( theElements );
}

inline const Tstring& St02RunInformationExtractor::GetElementTag( Tint index ) const
{
  return( theElementTags[ index ] );
}

inline const Tstring& St02RunInformationExtractor::GetElement( Tint index ) const
{
  return( theElements[ index ] );
}

#endif
