// =====================================================================
//  $Id: TCommandTable.hh,v 1.2 2003/07/30 16:17:31 goiwai Exp $
//  $Name: CLDAQ-1-08-00 $
//
//  $Log: TCommandTable.hh,v $
//  Revision 1.2  2003/07/30 16:17:31  goiwai
//  ե˥ߥåȥĤ뤳Ȥˤޤ.
//
// =====================================================================
#ifndef __TCOMMANDTABLE_HH
#define __TCOMMANDTABLE_HH

#include "Tglobals.h"
#include "TCommandSpecified.hh"

class TCommandTable
  : public Tvector<TCommandSpecified>
{

  public:
    TCommandTable();
    ~TCommandTable();

  public:
    TCommand* FindCommand( const Tstring& fullname ) const;
    TCommand* FindCommand( const Tstring& name, const Tstring& path ) const;
    Tbool AlreadyExist( TCommand* command ) const;
    Tbool AlreadyExist( const Tstring& fullname ) const;
    Tbool AlreadyExist( const Tstring& name, const Tstring& path ) const;
    Tbool AlreadyExistDirectory( const Tstring& path ) const;
    Tbool AlreadyExistDirectory( const Tstring& name, const Tstring& path ) const;
    Tvoid AddCommand( TCommand* command );
    Tvoid RemoveCommand( Tint index );
    Tint GetSize() const;
    Tvoid Clear();
    TstringList GetDirectoryList( const Tstring& path = "/" ) const;
    TstringList GetCommandList( const Tstring& path = "/" ) const;
    TstringList Sort( const Tstring& path = "/" ) const;
    TstringList Sort( const TstringList& sort ) const;
    Tvoid List( Tint column, const TstringList& strlist ) const;
    Tvoid List( Tint column, const Tstring& path = "/" ) const;
    TCommandSpecified GetCommandSpecified( Tint index ) const;
    TCommandSpecified GetCommandSpecified( const Tstring& fullname ) const;

  private:
    TCommandSpecified convert( TCommand* command ) const;

};

#endif
