// =====================================================================
//  $Id: TObjectSharedMemory.cc,v 1.2 2003/07/30 16:19:31 goiwai Exp $
//  $Name: CLDAQ-1-08-00 $
//
//  $Log: TObjectSharedMemory.cc,v $
//  Revision 1.2  2003/07/30 16:19:31  goiwai
//  ե˥ߥåȥĤ뤳Ȥˤޤ.
//
// =====================================================================
#include "TObjectSharedMemory.hh"

TObjectSharedMemory* TObjectSharedMemory::theObjectSharedMemory = 0;

TObjectSharedMemory::TObjectSharedMemory( Tint memsize, Tint maxevt )
  : theSharedMemoryID( -1 ), theMemorySize( memsize ),
    theMaxEvent( maxevt ), theCurrentPositionOfMemorySpace( 0 ),
    theReadable( 0 ), theBaseAddress( 0 ), theAddress( 0 )
{
  Tstring head = "TObjectSharedMemory::TObjectSharedMemory: ";

  theSharedMemoryID =
    shmget( ftok( getenv( "HOME" ), Tkey ), theMemorySize, 0666 | IPC_CREAT );
  if ( theSharedMemoryID == -1 ) {
    Tcerr << head << "failed getting shared memory ID." << Tendl;
    exit( -errno );
  }
  Tvoid* voidbuf = Attach();
  if ( voidbuf == (Tvoid*)-1 ) {
    Tcerr << head << "failed attach." << Tendl;
    exit( -errno );
  }

  theReadable = (Tbool*)voidbuf;
  SetReadable( Tfalse );

  ( (Tbool*)voidbuf ) ++;
  theBaseAddress = voidbuf;
  theAddress = theBaseAddress;
  theObjectSharedMemory = this;
}

TObjectSharedMemory::~TObjectSharedMemory()
// When output object destruct, invoked Dettach(), Remove() functions.
{
  theObjectSharedMemory = 0;
}
