// =====================================================================
//  $Id: TObjectSharedMemory.hh,v 1.2 2003/07/30 16:19:31 goiwai Exp $
//  $Name: CLDAQ-1-08-00 $
//
//  $Log: TObjectSharedMemory.hh,v $
//  Revision 1.2  2003/07/30 16:19:31  goiwai
//  ե˥ߥåȥĤ뤳Ȥˤޤ.
//
// =====================================================================
#ifndef __TOBJECTSHAREDMEMORY_HH
#define __TOBJECTSHAREDMEMORY_HH

#include "Tglobals.h"

//OutputƤȤInputʤ
class TObjectSharedMemory
{

  protected:
    static TObjectSharedMemory* theObjectSharedMemory;

  public:
    enum { tDefaultMaxEvent = 100 };
    enum { tDefaultMemorySize = 1024 * 1024 };
    
  protected:
    Tint theSharedMemoryID;
    Tint theMemorySize;
    Tint theMaxEvent;
    Tint theCurrentPositionOfMemorySpace;
    Tbool* theReadable;
    Tvoid* theBaseAddress;
    Tvoid* theAddress;

  public:
    TObjectSharedMemory( Tint memsize, Tint maxevt );

  protected:
    virtual ~TObjectSharedMemory();

  public:
    Tvoid* Attach( const Tvoid* shmaddr = 0, Tint shmflg = 0 ) const;
    Tint Detach();
    Tint Remove( struct shmid_ds* buf = 0 );

  public:
    Tint GetSharedMemoryID() const;
    Tint GetMemorySize() const;
    Tvoid* GetBaseAddress() const;
    Tvoid* GetAddress() const;
    Tint GetMaxEvent() const;
    Tint GetCurrentPositionOfMemorySpace() const;
    Tvoid SetMaxEvent( Tint maxevt );
    Tvoid SetCurrentPositionOfMemorySpace( Tint pos );
    Tvoid SetSharedMemoryID( Tint memid );
    Tvoid SetMemorySize( Tint memsize );
    Tvoid SetAddress( Tvoid* shmaddr );
    Tbool IsReadable() const;
    Tvoid SetReadable( Tbool permission );

  public:
    static TObjectSharedMemory* GetObjectSharedMemory();

};

inline TObjectSharedMemory* TObjectSharedMemory::GetObjectSharedMemory()
{
  return( theObjectSharedMemory );
}

inline Tint TObjectSharedMemory::GetMaxEvent() const
{
  return( theMaxEvent );
}

inline Tint TObjectSharedMemory::GetCurrentPositionOfMemorySpace() const
{
  return( theCurrentPositionOfMemorySpace );
}

inline Tvoid TObjectSharedMemory::SetMaxEvent( Tint maxevt )
{
  theMaxEvent = maxevt;
  return;
}

inline Tvoid TObjectSharedMemory::SetCurrentPositionOfMemorySpace( Tint pos )
{
  theCurrentPositionOfMemorySpace = pos;
  return;
}

inline Tint TObjectSharedMemory::GetSharedMemoryID() const
{
  return( theSharedMemoryID );
}

inline Tint TObjectSharedMemory::GetMemorySize() const
{
  return( theMemorySize );
}

inline Tvoid* TObjectSharedMemory::GetBaseAddress() const
{
  return( theBaseAddress );
}

inline Tvoid* TObjectSharedMemory::GetAddress() const
{
  return( theAddress );
}

inline Tvoid TObjectSharedMemory::SetSharedMemoryID( Tint memid )
{
  theSharedMemoryID = memid;
  return;
}

inline Tvoid TObjectSharedMemory::SetMemorySize( Tint memsize )
{
  theMemorySize = memsize;
  return;
}

inline Tvoid TObjectSharedMemory::SetAddress( Tvoid* shmaddr )
{
  theAddress = shmaddr;
  return;
}

inline Tvoid* TObjectSharedMemory::Attach( const Tvoid* shmaddr, Tint shmflg ) const
{
  return( shmat( theSharedMemoryID, shmaddr, shmflg ) );
}

inline Tint TObjectSharedMemory::Detach()
{
  return( shmdt( (Tvoid*)theReadable ) );
}

inline Tint TObjectSharedMemory::Remove( struct shmid_ds* buf )
{
  return( shmctl( theSharedMemoryID, IPC_RMID, buf ) );
}

inline Tbool TObjectSharedMemory::IsReadable() const
{
  return( *theReadable );
}

inline Tvoid TObjectSharedMemory::SetReadable( Tbool permission )
{
  *theReadable = permission;
  return;
}

#endif
