// =====================================================================
//  $Id: TObjectSocket.hh,v 1.2 2003/07/30 16:19:31 goiwai Exp $
//  $Name: CLDAQ-1-08-00 $
//
//  $Log: TObjectSocket.hh,v $
//  Revision 1.2  2003/07/30 16:19:31  goiwai
//  ե˥ߥåȥĤ뤳Ȥˤޤ.
//
// =====================================================================
#ifndef __TOBJECTSOCKET_HH
#define __TOBJECTSOCKET_HH

#include "Tglobals.h"

class TObjectSocket
{

  protected:
    enum { tDefaultPortNumber = 18150 };

  protected:
    Tint theServerDescriptor;
    Tint thePortNumber;
    struct sockaddr_in theAddress;

  public:
    TObjectSocket( Tint portnumber );

  protected:
    virtual ~TObjectSocket();

  public:
    Tint GetServerDescriptor() const;
    Tint GetPortNumber() const;

  public:
    Tint OpenServer();
    Tint CloseServer();

};

inline Tint TObjectSocket::GetServerDescriptor() const
{
  return( theServerDescriptor );
}

inline Tint TObjectSocket::GetPortNumber() const
{
  return( thePortNumber );
}

#endif
