// =====================================================================
//  $Id: TRun.hh,v 1.6 2003/07/30 16:20:30 goiwai Exp $
//  $Name: CLDAQ-1-08-00 $
//
//  $Log: TRun.hh,v $
//  Revision 1.6  2003/07/30 16:20:30  goiwai
//  ե˥ߥåȥĤ뤳Ȥˤޤ.
//
// =====================================================================
#ifndef __TRUN_HH
#define __TRUN_HH

#include "Tglobals.h"
#include "TEventStack.hh"

class TRun
{

  private:
    Tint theRunID;
    TEventStack theEventStack;

  public:
    TRun( Tint runid = 0 );
    TRun( const TEventStack& eventstack );
    TRun( Tint runid, const TEventStack& eventstack );
    TRun( const TRun& right );
    virtual ~TRun();

  public:
    const TRun& operator=( const TRun& right );
    Tbool operator==( const TRun& right ) const;
    Tbool operator!=( const TRun& right ) const;

  public:
    Tint GetRunID() const;
    Tvoid SetRunID( Tint runid );
    const TEventStack& GetEventStack() const;
    TEventStack& GetEventStack();
    Tvoid SetEventStack( const TEventStack& eventstack );

  public:
    virtual Tvoid Clear();
    virtual Tstring GetStringRunID( Tint digits = 6 ) const;

};

inline Tint TRun::GetRunID() const
{
  return( theRunID );
}
inline const TEventStack& TRun::GetEventStack() const
{
  return( theEventStack );
}

inline TEventStack& TRun::GetEventStack()
{
  return( theEventStack );
}

inline Tvoid TRun::SetRunID( Tint runid )
{
  theRunID = runid;
  return;
}

inline Tvoid TRun::SetEventStack( const TEventStack& eventstack )
{
  theEventStack = eventstack;
  return;
}

#endif
