// =====================================================================
//  $Id: Rs01VdcViewCommand.cc,v 1.3 2003/07/30 16:14:41 goiwai Exp $
//  $Name: CLDAQ-1-08-01 $
//
//  $Log: Rs01VdcViewCommand.cc,v $
//  Revision 1.3  2003/07/30 16:14:41  goiwai
//  ե˥ߥåȥĤ뤳Ȥˤޤ.
//
// =====================================================================
#include "TRunManager.hh"
#include "TUserInterface.hh"
#include "TOutputObjectFile.hh"
#include "TEnvironmentVariableTable.hh"

#include "Rs01VdcViewCommand.hh"
#include "Rs01RunAction.hh"

static const Tstring _name = "/local/rs01vdcview";
static const Tstring _desc = "KEITHLEY Multimeter Model 2700 with 7702";

Rs01VdcViewCommand::Rs01VdcViewCommand()
  : TCommand( _name, _desc )
{;}

Rs01VdcViewCommand::~Rs01VdcViewCommand()
{;}

Tvoid Rs01VdcViewCommand::Execute( const TstringList& arguments )
{
  const TEnvironmentVariableTable& envtable =
    theRunManager -> GetEnvironmentVariableTable();
  Tstring bindir = envtable.GetEnvironmentValue( "RS01_BIN_DIR" );

  TstringList args;
  Tstring comname = bindir + Tslash + "rs01vdcview";
  Tint runid = theRunManager -> GetRun().GetRunID();

  args.push_back( comname );
  args.push_back( itostr( runid, 0 ) );
  args.push_back( "&" );

  TUserInterface* ui = theRunManager -> GetUserInterface();
  Tstring com = "/system/shell";
  ui -> ExecuteCommand( com, args );

  return;
}
