// =====================================================================
//  $Id: St01RunSummary.hh,v 1.2 2003/07/30 16:16:11 goiwai Exp $
//  $Name: CLDAQ-1-08-01 $
//
//  $Log: St01RunSummary.hh,v $
//  Revision 1.2  2003/07/30 16:16:11  goiwai
//  ե˥ߥåȥĤ뤳Ȥˤޤ.
//
// =====================================================================
#ifndef __ST01RUNSUMMARY_HH
#define __ST01RUNSUMMARY_HH

#include "TRunInformationTable.hh"
#include "TChannel.hh"

class St01RunSummary
{

  private:
    Tint theRunID;
    Tstring theRecordName;
    Tint theRecordSize;
    Tint theNumberOfEvents;
    TRunInformationTable theRunInformationTable;
    Tstring theRunBeginTime;
    Tstring theRunEndTime;
    // I wish ...
    Tdouble theTempAve;
    Tdouble theTempMax;
    Tdouble theTempMin;
    Tdouble theDarkAve;
    Tdouble theDarkMax;
    Tdouble theDarkMin;
    Tdouble theSignalAve;
    Tdouble theSignalMax;
    Tdouble theSignalMin;
    Tdouble theHocAve;

  public:
    St01RunSummary();
    ~St01RunSummary();

  public:
    TRunInformationTable GenerateRunSummaryTable() const;
    Tvoid Initialize();

  public:
    Tint GetRunID() const;
    const Tstring& GetRecordName() const;
    Tint GetRecordSize() const;
    Tint GetNumberOfEvents() const;
    const TRunInformationTable& GetRunInformationTable() const;
    const Tstring& GetRunBeginTime() const;
    const Tstring& GetRunEndTime() const;
    Tvoid SetRunID( Tint runid );
    Tvoid SetRecordName( const Tstring& recname );
    Tvoid SetRecordSize( Tint size );
    Tvoid SetNumberOfEvents( Tint nevents );
    Tvoid SetRunInformationTable( const TRunInformationTable& table );
    Tvoid SetRunBeginTime( const Tstring& time );
    Tvoid SetRunEndTime( const Tstring& time );

    Tdouble GetTempAve() const;
    Tdouble GetTempMax() const;
    Tdouble GetTempMin() const;
    Tdouble GetDarkAve() const;
    Tdouble GetDarkMax() const;
    Tdouble GetDarkMin() const;
    Tdouble GetSignalAve() const;
    Tdouble GetSignalMax() const;
    Tdouble GetSignalMin() const;
    Tdouble GetHocAve() const;
    Tvoid SetTempAve( Tdouble temp );
    Tvoid SetTempMax( Tdouble temp );
    Tvoid SetTempMin( Tdouble temp );
    Tvoid SetDarkAve( Tdouble dark );
    Tvoid SetDarkMax( Tdouble dark );
    Tvoid SetDarkMin( Tdouble dark );
    Tvoid SetSignalAve( Tdouble signal );
    Tvoid SetSignalMax( Tdouble signal );
    Tvoid SetSignalMin( Tdouble signal );
    Tvoid SetHocAve( Tdouble hoc );

};

inline Tint St01RunSummary::GetRunID() const
{
  return( theRunID );
}

inline const Tstring& St01RunSummary::GetRecordName() const
{
  return( theRecordName );
}

inline Tint St01RunSummary::GetRecordSize() const
{
  return( theRecordSize );
}

inline Tint St01RunSummary::GetNumberOfEvents() const
{
  return( theNumberOfEvents );
}

inline const TRunInformationTable& St01RunSummary::GetRunInformationTable() const
{
  return( theRunInformationTable );
}

inline const Tstring& St01RunSummary::GetRunBeginTime() const
{
  return( theRunBeginTime );
}

inline const Tstring& St01RunSummary::GetRunEndTime() const
{
  return( theRunEndTime );
}

inline Tvoid St01RunSummary::SetRunID( Tint runid )
{
  theRunID = runid;
  return;
}

inline Tvoid St01RunSummary::SetRecordName( const Tstring& recname )
{
  theRecordName = recname;
  return;
}

inline Tvoid St01RunSummary::SetRecordSize( Tint size )
{
  theRecordSize = size;
  return;
}

inline Tvoid St01RunSummary::SetNumberOfEvents( Tint nevents )
{
  theNumberOfEvents = nevents;
  return;
}

inline Tvoid St01RunSummary::SetRunInformationTable( const TRunInformationTable& table )
{
  theRunInformationTable = table;
  return;
}

inline Tvoid St01RunSummary::SetRunBeginTime( const Tstring& time )
{
  theRunBeginTime = time;
  return;
}

inline Tvoid St01RunSummary::SetRunEndTime( const Tstring& time )
{
  theRunEndTime = time;
  return;
}

inline Tdouble St01RunSummary::GetTempAve() const
{
  return( theTempAve );
}

inline Tdouble St01RunSummary::GetTempMax() const
{
  return( theTempMax );
}

inline Tdouble St01RunSummary::GetTempMin() const
{
  return( theTempMin );
}

inline Tdouble St01RunSummary::GetDarkAve() const
{
  return( theDarkAve );
}

inline Tdouble St01RunSummary::GetDarkMax() const
{
  return( theDarkMax );
}

inline Tdouble St01RunSummary::GetDarkMin() const
{
  return( theDarkMin );
}

inline Tdouble St01RunSummary::GetSignalAve() const
{
  return( theSignalAve );
}

inline Tdouble St01RunSummary::GetSignalMax() const
{
  return( theSignalMax );
}

inline Tdouble St01RunSummary::GetSignalMin() const
{
  return( theSignalMin );
}

inline Tdouble St01RunSummary::GetHocAve() const
{
  return( theHocAve );
}

inline Tvoid St01RunSummary::SetTempAve( Tdouble temp )
{
  theTempAve = temp;
  return;
}

inline Tvoid St01RunSummary::SetTempMax( Tdouble temp )
{
  theTempMax = temp;
  return;
}

inline Tvoid St01RunSummary::SetTempMin( Tdouble temp )
{
  theTempMin = temp;
  return;
}

inline Tvoid St01RunSummary::SetDarkAve( Tdouble dark )
{
  theDarkAve = dark;
  return;
}

inline Tvoid St01RunSummary::SetDarkMax( Tdouble dark )
{
  theDarkMax = dark;
  return;
}

inline Tvoid St01RunSummary::SetDarkMin( Tdouble dark )
{
  theDarkMin = dark;
  return;
}

inline Tvoid St01RunSummary::SetSignalAve( Tdouble signal )
{
  theSignalAve = signal;
  return;
}

inline Tvoid St01RunSummary::SetSignalMax( Tdouble signal )
{
  theSignalMax = signal;
  return;
}

inline Tvoid St01RunSummary::SetSignalMin( Tdouble signal )
{
  theSignalMin = signal;
  return;
}

inline Tvoid St01RunSummary::SetHocAve( Tdouble hoc )
{
  theHocAve = hoc;
  return;
}

#endif
