// =====================================================================
//  $Id: TChangeDirectoryCommand.cc,v 1.2 2003/07/30 16:17:30 goiwai Exp $
//  $Name: CLDAQ-1-08-01 $
//
//  $Log: TChangeDirectoryCommand.cc,v $
//  Revision 1.2  2003/07/30 16:17:30  goiwai
//  ե˥ߥåȥĤ뤳Ȥˤޤ.
//
// =====================================================================
#include "TChangeDirectoryCommand.hh"
#include "TRunManager.hh"
#include "TUserInterface.hh"

static const Tstring _name = "cd";
static const Tstring _desc = "change the current directory.";

TChangeDirectoryCommand::TChangeDirectoryCommand( TRunManager* manager )
  : TCommand( manager, _name, _desc )
{;}

TChangeDirectoryCommand::~TChangeDirectoryCommand()
{;}

Tvoid TChangeDirectoryCommand::Execute( const TstringList& arguments )
{
  TUserInterface* ui = theRunManager -> GetUserInterface();
  if ( ui == 0 ) {
    return;
  }

  if ( arguments.empty() ) {
    ui -> SetCurrentWorkingDirectory( "/" );
  } else if ( arguments.size() == 1 ) {
    ui -> SetCurrentWorkingDirectory( arguments[ 0 ] );
  } else {
    Tcerr << "TChangeDirectoryCommand::Execute: Too many arguments." << Tendl;
  }
  return;
}
